/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.magic;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.Map;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.getter.TypeGetter;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.io.resource.UriResource;
import org.aoju.bus.core.io.watcher.SimpleWatcher;
import org.aoju.bus.core.io.watcher.WatchMonitor;
import org.aoju.bus.core.io.watcher.Watcher;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.function.XFunction;
import org.aoju.bus.core.lang.function.XSupplier;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.LambdaKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.WatchKit;
import org.aoju.bus.logger.Logger;

public final class Properties
extends java.util.Properties
implements TypeGetter<CharSequence> {
    private static final long serialVersionUID = 1L;
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient java.nio.charset.Charset charset = Charset.ISO_8859_1;

    public Properties(String path) {
        this(path, null);
    }

    public Properties(String path, java.nio.charset.Charset charset) {
        Assert.notBlank((CharSequence)path, (String)"Blank properties file path !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(FileKit.getUrl((String)path, Properties.class));
    }

    public Properties(File propertiesFile) {
        this(propertiesFile, null);
    }

    public Properties() {
    }

    public Properties(File propertiesFile, java.nio.charset.Charset charset) {
        Assert.notNull((Object)propertiesFile, (String)"Null properties file!", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(FileKit.getResource((File)propertiesFile));
    }

    public Properties(Resource resource, java.nio.charset.Charset charset) {
        Assert.notNull((Object)resource, (String)"Null properties URL !", (Object[])new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(resource);
    }

    public Properties(java.util.Properties properties) {
        if (MapKit.isNotEmpty((Map)properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public static Properties of() {
        return new Properties();
    }

    public static Properties of(String resource) {
        return new Properties(resource);
    }

    public static Properties of(String resource, java.nio.charset.Charset charset) {
        return new Properties(resource, charset);
    }

    public void load(URL url) {
        this.load((Resource)new UriResource(url));
    }

    public void load(Resource resource) {
        Assert.notNull((Object)resource, (String)"Props resource must be not null!", (Object[])new Object[0]);
        this.resource = resource;
        try (BufferedReader reader = resource.getReader(this.charset);){
            super.load(reader);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull((Object)this.resource, (String)"Properties resource must be not null!", (Object[])new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchKit.createModify((URL)this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Properties.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoKit.close((Closeable)this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public Object getObject(CharSequence key, Object defaultValue) {
        return ObjectKit.defaultIfNull((Object)this.getProperty(StringKit.toString((CharSequence)key)), (Object)defaultValue);
    }

    public <P, T> T get(XFunction<P, T> func) {
        LambdaKit.Info lambdaInfo = LambdaKit.resolve(func);
        return (T)this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    public String getAndRemoveString(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public java.util.Properties toProperties() {
        java.util.Properties properties = new java.util.Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        Object bean = ReflectKit.newInstanceIfPossible(beanClass);
        return (T)this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StringKit.emptyIfNull((CharSequence)StringKit.addSuffixIfNot((CharSequence)prefix, (CharSequence)"."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StringKit.startWith((CharSequence)key, (CharSequence)prefix)) continue;
            try {
                BeanKit.setProperty(bean, (String)StringKit.subSuf((CharSequence)key, (int)prefix.length()), (Object)entry.getValue());
            }
            catch (Exception e) {
                Logger.debug((String)"Ignore property: [{}]", (Object[])new Object[]{key});
            }
        }
        return bean;
    }

    public void set(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public Properties setFields(XSupplier<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaKit.getFieldName((Serializable)f), f.get()));
        return this;
    }

    public void store(String absolutePath) throws InternalException {
        BufferedWriter writer = null;
        try {
            writer = FileKit.getWriter((String)absolutePath, (java.nio.charset.Charset)this.charset, (boolean)false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new InternalException((Throwable)e, "Store properties to [{}] error!", new Object[]{absolutePath});
            }
            catch (Throwable throwable) {
                IoKit.close(writer);
                throw throwable;
            }
        }
        IoKit.close((Closeable)writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileKit.getAbsolutePath((String)path, clazz));
    }
}

