/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.entity;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.shade.NamingRules;
import org.aoju.bus.shade.entity.PropertyInfo;

public class TableEntity
implements Serializable {
    private String project;
    private String author;
    private String version;
    private String dbUrl;
    private String dbName;
    private String dbPassword;
    private String database;
    private String table;
    private String entityName;
    private String objectName;
    private String entityComment;
    private String createTime;
    private String agile;
    private String entityUrl;
    private String mapperUrl;
    private String mapperXmlUrl;
    private String serviceUrl;
    private String serviceImplUrl;
    private String controllerUrl;
    private String idType;
    private String idJdbcType;
    private List<PropertyInfo> cis;
    private String isSwagger = "true";

    public TableEntity(String project, String author, String version, String dbUrl, String dbName, String dbPassword, String database, String table, String agile, String entityUrl, String mapperUrl, String mapperXmlUrl, String serviceUrl, String serviceImplUrl, String controllerUrl, String isSwagger) {
        this.project = project;
        this.author = author;
        this.version = version;
        this.dbUrl = dbUrl.replace("database", database);
        this.dbName = dbName;
        this.dbPassword = dbPassword;
        this.database = database;
        this.table = table;
        this.agile = agile;
        this.entityUrl = entityUrl;
        this.mapperUrl = mapperUrl;
        this.mapperXmlUrl = mapperXmlUrl;
        this.serviceUrl = serviceUrl;
        this.serviceImplUrl = serviceImplUrl;
        this.controllerUrl = controllerUrl;
        this.isSwagger = isSwagger;
    }

    public static TableEntity get(TableEntity bi) {
        ArrayList<PropertyInfo> columns = new ArrayList<PropertyInfo>();
        Connection con = null;
        Statement pstemt = null;
        ResultSet rs = null;
        String sql = "select column_name,data_type,column_comment from information_schema.columns where table_schema='" + bi.getDatabase() + "' and table_name='" + bi.getTable() + "'";
        try {
            Object column;
            con = DriverManager.getConnection(bi.getDbUrl(), bi.getDbName(), bi.getDbPassword());
            pstemt = con.prepareStatement(sql);
            rs = pstemt.executeQuery();
            while (rs.next()) {
                column = rs.getString(1);
                String jdbcType = rs.getString(2);
                String comment = rs.getString(3);
                PropertyInfo ci = new PropertyInfo();
                ci.setColumn((String)column);
                if (jdbcType.equalsIgnoreCase("int")) {
                    ci.setJdbcType("Integer");
                } else if (jdbcType.equalsIgnoreCase("datetime")) {
                    ci.setJdbcType("timestamp");
                } else {
                    ci.setJdbcType(jdbcType);
                }
                ci.setComment(comment);
                ci.setProperty(NamingRules.changeToJavaFiled((String)column, false));
                ci.setJavaType(NamingRules.jdbcTypeToJavaType(jdbcType));
                if (((String)column).equalsIgnoreCase("id")) {
                    bi.setIdType(ci.getJavaType());
                    bi.setIdJdbcType(ci.getJdbcType());
                }
                columns.add(ci);
            }
            bi.setCis(columns);
            rs.close();
            pstemt.close();
            con.close();
            if (null == columns || columns.size() == 0) {
                throw new RuntimeException("\u672a\u80fd\u8bfb\u53d6\u5230\u8868\u6216\u8868\u4e2d\u7684\u5b57\u6bb5\u3002\u8bf7\u68c0\u67e5\u94fe\u63a5url\uff0c\u6570\u636e\u5e93\u8d26\u6237\uff0c\u6570\u636e\u5e93\u5bc6\u7801\uff0c\u67e5\u8be2\u7684\u6570\u636e\u540d\u3001\u662f\u5426\u6b63\u786e\u3002");
            }
            column = bi;
            return column;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u81ea\u52a8\u751f\u6210\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (pstemt != null) {
                    pstemt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public String getProject() {
        return this.project;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getEntityComment() {
        return this.entityComment;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getAgile() {
        return this.agile;
    }

    public String getEntityUrl() {
        return this.entityUrl;
    }

    public String getMapperUrl() {
        return this.mapperUrl;
    }

    public String getMapperXmlUrl() {
        return this.mapperXmlUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceImplUrl() {
        return this.serviceImplUrl;
    }

    public String getControllerUrl() {
        return this.controllerUrl;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getIdJdbcType() {
        return this.idJdbcType;
    }

    public List<PropertyInfo> getCis() {
        return this.cis;
    }

    public String getIsSwagger() {
        return this.isSwagger;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setEntityComment(String entityComment) {
        this.entityComment = entityComment;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setAgile(String agile) {
        this.agile = agile;
    }

    public void setEntityUrl(String entityUrl) {
        this.entityUrl = entityUrl;
    }

    public void setMapperUrl(String mapperUrl) {
        this.mapperUrl = mapperUrl;
    }

    public void setMapperXmlUrl(String mapperXmlUrl) {
        this.mapperXmlUrl = mapperXmlUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceImplUrl(String serviceImplUrl) {
        this.serviceImplUrl = serviceImplUrl;
    }

    public void setControllerUrl(String controllerUrl) {
        this.controllerUrl = controllerUrl;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public void setIdJdbcType(String idJdbcType) {
        this.idJdbcType = idJdbcType;
    }

    public void setCis(List<PropertyInfo> cis) {
        this.cis = cis;
    }

    public void setIsSwagger(String isSwagger) {
        this.isSwagger = isSwagger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableEntity)) {
            return false;
        }
        TableEntity other = (TableEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$dbUrl = this.getDbUrl();
        String other$dbUrl = other.getDbUrl();
        if (this$dbUrl == null ? other$dbUrl != null : !this$dbUrl.equals(other$dbUrl)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$dbPassword = this.getDbPassword();
        String other$dbPassword = other.getDbPassword();
        if (this$dbPassword == null ? other$dbPassword != null : !this$dbPassword.equals(other$dbPassword)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        String this$entityComment = this.getEntityComment();
        String other$entityComment = other.getEntityComment();
        if (this$entityComment == null ? other$entityComment != null : !this$entityComment.equals(other$entityComment)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$agile = this.getAgile();
        String other$agile = other.getAgile();
        if (this$agile == null ? other$agile != null : !this$agile.equals(other$agile)) {
            return false;
        }
        String this$entityUrl = this.getEntityUrl();
        String other$entityUrl = other.getEntityUrl();
        if (this$entityUrl == null ? other$entityUrl != null : !this$entityUrl.equals(other$entityUrl)) {
            return false;
        }
        String this$mapperUrl = this.getMapperUrl();
        String other$mapperUrl = other.getMapperUrl();
        if (this$mapperUrl == null ? other$mapperUrl != null : !this$mapperUrl.equals(other$mapperUrl)) {
            return false;
        }
        String this$mapperXmlUrl = this.getMapperXmlUrl();
        String other$mapperXmlUrl = other.getMapperXmlUrl();
        if (this$mapperXmlUrl == null ? other$mapperXmlUrl != null : !this$mapperXmlUrl.equals(other$mapperXmlUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$serviceImplUrl = this.getServiceImplUrl();
        String other$serviceImplUrl = other.getServiceImplUrl();
        if (this$serviceImplUrl == null ? other$serviceImplUrl != null : !this$serviceImplUrl.equals(other$serviceImplUrl)) {
            return false;
        }
        String this$controllerUrl = this.getControllerUrl();
        String other$controllerUrl = other.getControllerUrl();
        if (this$controllerUrl == null ? other$controllerUrl != null : !this$controllerUrl.equals(other$controllerUrl)) {
            return false;
        }
        String this$idType = this.getIdType();
        String other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        String this$idJdbcType = this.getIdJdbcType();
        String other$idJdbcType = other.getIdJdbcType();
        if (this$idJdbcType == null ? other$idJdbcType != null : !this$idJdbcType.equals(other$idJdbcType)) {
            return false;
        }
        List<PropertyInfo> this$cis = this.getCis();
        List<PropertyInfo> other$cis = other.getCis();
        if (this$cis == null ? other$cis != null : !((Object)this$cis).equals(other$cis)) {
            return false;
        }
        String this$isSwagger = this.getIsSwagger();
        String other$isSwagger = other.getIsSwagger();
        return !(this$isSwagger == null ? other$isSwagger != null : !this$isSwagger.equals(other$isSwagger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $dbUrl = this.getDbUrl();
        result = result * 59 + ($dbUrl == null ? 43 : $dbUrl.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $dbPassword = this.getDbPassword();
        result = result * 59 + ($dbPassword == null ? 43 : $dbPassword.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        String $entityComment = this.getEntityComment();
        result = result * 59 + ($entityComment == null ? 43 : $entityComment.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $agile = this.getAgile();
        result = result * 59 + ($agile == null ? 43 : $agile.hashCode());
        String $entityUrl = this.getEntityUrl();
        result = result * 59 + ($entityUrl == null ? 43 : $entityUrl.hashCode());
        String $mapperUrl = this.getMapperUrl();
        result = result * 59 + ($mapperUrl == null ? 43 : $mapperUrl.hashCode());
        String $mapperXmlUrl = this.getMapperXmlUrl();
        result = result * 59 + ($mapperXmlUrl == null ? 43 : $mapperXmlUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $serviceImplUrl = this.getServiceImplUrl();
        result = result * 59 + ($serviceImplUrl == null ? 43 : $serviceImplUrl.hashCode());
        String $controllerUrl = this.getControllerUrl();
        result = result * 59 + ($controllerUrl == null ? 43 : $controllerUrl.hashCode());
        String $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        String $idJdbcType = this.getIdJdbcType();
        result = result * 59 + ($idJdbcType == null ? 43 : $idJdbcType.hashCode());
        List<PropertyInfo> $cis = this.getCis();
        result = result * 59 + ($cis == null ? 43 : ((Object)$cis).hashCode());
        String $isSwagger = this.getIsSwagger();
        result = result * 59 + ($isSwagger == null ? 43 : $isSwagger.hashCode());
        return result;
    }

    public String toString() {
        return "TableEntity(project=" + this.getProject() + ", author=" + this.getAuthor() + ", version=" + this.getVersion() + ", dbUrl=" + this.getDbUrl() + ", dbName=" + this.getDbName() + ", dbPassword=" + this.getDbPassword() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", entityName=" + this.getEntityName() + ", objectName=" + this.getObjectName() + ", entityComment=" + this.getEntityComment() + ", createTime=" + this.getCreateTime() + ", agile=" + this.getAgile() + ", entityUrl=" + this.getEntityUrl() + ", mapperUrl=" + this.getMapperUrl() + ", mapperXmlUrl=" + this.getMapperXmlUrl() + ", serviceUrl=" + this.getServiceUrl() + ", serviceImplUrl=" + this.getServiceImplUrl() + ", controllerUrl=" + this.getControllerUrl() + ", idType=" + this.getIdType() + ", idJdbcType=" + this.getIdJdbcType() + ", cis=" + this.getCis() + ", isSwagger=" + this.getIsSwagger() + ")";
    }
}

