/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade;

import java.util.List;
import org.aoju.bus.shade.Freemarker;
import org.aoju.bus.shade.entity.PropertyInfo;
import org.aoju.bus.shade.entity.TableEntity;

public class ShadeFile {
    public static final String ENTITY = "Entity";
    public static final String MAPPER = "Mapper";
    public static final String MAPPER_XML = "MapperXml";
    public static final String SERVICE = "Service";
    public static final String SERVICE_IMPL = "ServiceImpl";
    public static final String CONTROLLER = "Controller";
    public static final String SUFFIX = ".ftl";

    public static Object createEntity(String url, TableEntity bi) {
        String fileUrl = ShadeFile.getFileUrl(url, bi.getEntityUrl(), bi.getEntityName(), ENTITY);
        return Freemarker.createFile(bi, "Entity.ftl", fileUrl);
    }

    public static Object createMapper(String url, TableEntity bi) {
        String fileUrl = ShadeFile.getFileUrl(url, bi.getMapperUrl(), bi.getEntityName(), MAPPER);
        return Freemarker.createFile(bi, "Mapper.ftl", fileUrl);
    }

    public static Object createMapperXml(String url, TableEntity bi) {
        String fileUrl = ShadeFile.getFileUrl(url, bi.getMapperXmlUrl(), bi.getEntityName(), MAPPER_XML);
        List<PropertyInfo> list = bi.getCis();
        String agile = "";
        for (PropertyInfo propertyInfo : list) {
            agile = agile + propertyInfo.getColumn() + ",\n\t\t";
        }
        agile = agile.substring(0, agile.length() - 4);
        bi.setAgile(agile);
        return Freemarker.createFile(bi, "MapperXml.ftl", fileUrl);
    }

    public static Object createService(String url, TableEntity bi) {
        String fileUrl = ShadeFile.getFileUrl(url, bi.getServiceUrl(), bi.getEntityName(), SERVICE);
        return Freemarker.createFile(bi, "Service.ftl", fileUrl);
    }

    public static Object createServiceImpl(String url, TableEntity bi) {
        String fileUrl = ShadeFile.getFileUrl(url, bi.getServiceImplUrl(), bi.getEntityName(), SERVICE_IMPL);
        return Freemarker.createFile(bi, "ServiceImpl.ftl", fileUrl);
    }

    public static Object createController(String url, TableEntity bi) {
        String fileUrl = ShadeFile.getFileUrl(url, bi.getControllerUrl(), bi.getEntityName(), CONTROLLER);
        return Freemarker.createFile(bi, "Controller.ftl", fileUrl);
    }

    public static String getFileUrl(String url, String packageUrl, String entityName, String type) {
        if (ENTITY.equals(type)) {
            return url + ShadeFile.pageToUrl(packageUrl) + entityName + ".java";
        }
        if (MAPPER.equals(type)) {
            return url + ShadeFile.pageToUrl(packageUrl) + entityName + "Mapper.java";
        }
        if (MAPPER_XML.equals(type)) {
            return url + ShadeFile.pageToUrl(packageUrl) + entityName + "Mapper.xml";
        }
        if (SERVICE.equals(type)) {
            return url + ShadeFile.pageToUrl(packageUrl) + entityName + "Service.java";
        }
        if (SERVICE_IMPL.equals(type)) {
            return url + ShadeFile.pageToUrl(packageUrl) + entityName + "ServiceImpl.java";
        }
        if (CONTROLLER.equals(type)) {
            return url + ShadeFile.pageToUrl(packageUrl) + entityName + "Controller.java";
        }
        return null;
    }

    public static String pageToUrl(String url) {
        return url.replace(".", "/") + "/";
    }
}

