/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.aoju.bus.shade.Config;
import org.aoju.bus.shade.beans.PropertyInfo;
import org.aoju.bus.shade.beans.TableEntity;
import org.aoju.bus.shade.screw.execute.ProduceExecute;

public class Builder {
    public static final String ENTITY = "Entity";
    public static final String MAPPER = "Mapper";
    public static final String MAPPER_XML = "MapperXml";
    public static final String SERVICE = "Service";
    public static final String SERVICE_IMPL = "ServiceImpl";
    public static final String CONTROLLER = "Controller";
    public static final String SUFFIX = ".ftl";
    public static final String PERCENT_SIGN = "%";
    public static final String NOT_SUPPORTED = "Not supported yet!";
    public static final String DEFAULT_LOCALE = "zh_CN";
    public static final String MAC = "Mac";
    public static final String WINDOWS = "Windows";
    public static final String ZERO_DECIMAL_DIGITS = "0";
    public static final String DESCRIPTION = "\u6570\u636e\u5e93\u8bbe\u8ba1\u6587\u6863";
    public static final String USE_INFORMATION_SCHEMA = "useInformationSchema";
    public static final String ORACLE_REMARKS = "remarks";
    public static final String ZERO = "0";
    public static final String N = "N";
    public static final String Y = "Y";

    public static Object createEntity(String url, TableEntity bi) {
        String fileUrl = Builder.getFileUrl(url, bi.getEntityUrl(), bi.getEntityName(), ENTITY);
        return Builder.createFile(bi, "Entity.ftl", fileUrl);
    }

    public static Object createMapper(String url, TableEntity bi) {
        String fileUrl = Builder.getFileUrl(url, bi.getMapperUrl(), bi.getEntityName(), MAPPER);
        return Builder.createFile(bi, "Mapper.ftl", fileUrl);
    }

    public static Object createMapperXml(String url, TableEntity bi) {
        String fileUrl = Builder.getFileUrl(url, bi.getMapperXmlUrl(), bi.getEntityName(), MAPPER_XML);
        List<PropertyInfo> list = bi.getCis();
        String agile = "";
        for (PropertyInfo propertyInfo : list) {
            agile = agile + propertyInfo.getColumn() + ",\n\t\t";
        }
        agile = agile.substring(0, agile.length() - 4);
        bi.setAgile(agile);
        return Builder.createFile(bi, "MapperXml.ftl", fileUrl);
    }

    public static Object createService(String url, TableEntity bi) {
        String fileUrl = Builder.getFileUrl(url, bi.getServiceUrl(), bi.getEntityName(), SERVICE);
        return Builder.createFile(bi, "Service.ftl", fileUrl);
    }

    public static Object createServiceImpl(String url, TableEntity bi) {
        String fileUrl = Builder.getFileUrl(url, bi.getServiceImplUrl(), bi.getEntityName(), SERVICE_IMPL);
        return Builder.createFile(bi, "ServiceImpl.ftl", fileUrl);
    }

    public static Object createController(String url, TableEntity bi) {
        String fileUrl = Builder.getFileUrl(url, bi.getControllerUrl(), bi.getEntityName(), CONTROLLER);
        return Builder.createFile(bi, "Controller.ftl", fileUrl);
    }

    private static String getFileUrl(String url, String packageUrl, String entityName, String type) {
        if (ENTITY.equals(type)) {
            return url + packageUrl.replace(".", "/") + "/" + entityName + ".java";
        }
        if (MAPPER.equals(type)) {
            return url + packageUrl.replace(".", "/") + "/" + entityName + "Mapper.java";
        }
        if (MAPPER_XML.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "Mapper.xml";
        }
        if (SERVICE.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "Service.java";
        }
        if (SERVICE_IMPL.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "ServiceImpl.java";
        }
        if (CONTROLLER.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "Controller.java";
        }
        return null;
    }

    private static String pageToUrl(String url) {
        return url.replace(".", "/") + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object createFile(TableEntity dataModel, String templateName, String filePath) {
        OutputStreamWriter out = null;
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
            configuration.setClassForTemplateLoading(Builder.class, "/META-INF/template");
            configuration.setDefaultEncoding("utf-8");
            Template template = configuration.getTemplate(templateName);
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                String string = "The file already exists:" + filePath;
                return string;
            }
            file.createNewFile();
            out = new FileWriter(file);
            template.process((Object)dataModel, (Writer)out);
            String string = "create a file :" + filePath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "failed to create file :" + filePath;
    }

    public static void createFile(Config config) {
        new ProduceExecute(config).execute();
    }
}

