/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect;

import java.io.Serializable;
import org.aoju.bus.shade.screw.dialect.DatabaseQuery;
import org.aoju.bus.shade.screw.dialect.OtherDataBaseQuery;
import org.aoju.bus.shade.screw.dialect.cachedb.CacheDbDataBaseQuery;
import org.aoju.bus.shade.screw.dialect.db2.Db2DataBaseQuery;
import org.aoju.bus.shade.screw.dialect.h2.H2DataBaseQuery;
import org.aoju.bus.shade.screw.dialect.mariadb.MariaDbDataBaseQuery;
import org.aoju.bus.shade.screw.dialect.mysql.MySqlDataBaseQuery;
import org.aoju.bus.shade.screw.dialect.oracle.OracleDataBaseQuery;
import org.aoju.bus.shade.screw.dialect.postgresql.PostgreSqlDataBaseQuery;
import org.aoju.bus.shade.screw.dialect.sqlserver.SqlServerDataBaseQuery;

public enum DatabaseType implements Serializable
{
    CACHEDB("cachedb", "Cache \u6570\u636e\u5e93", CacheDbDataBaseQuery.class),
    DB2("db2", "DB2\u6570\u636e\u5e93", Db2DataBaseQuery.class),
    H2("h2", "H2\u6570\u636e\u5e93", H2DataBaseQuery.class),
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93", MariaDbDataBaseQuery.class),
    MYSQL("mysql", "MySql\u6570\u636e\u5e93", MySqlDataBaseQuery.class),
    ORACLE("oracle", "Oracle\u6570\u636e\u5e93", OracleDataBaseQuery.class),
    POSTGRE_SQL("PostgreSql", "Postgre\u6570\u636e\u5e93", PostgreSqlDataBaseQuery.class),
    SQL_SERVER2005("sqlServer2005", "SQLServer2005\u6570\u636e\u5e93", SqlServerDataBaseQuery.class),
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93", SqlServerDataBaseQuery.class),
    OTHER("other", "\u5176\u4ed6\u6570\u636e\u5e93", OtherDataBaseQuery.class);

    private final String name;
    private final String desc;
    private final Class<? extends DatabaseQuery> implClass;

    private DatabaseType(String name, String desc, Class<? extends DatabaseQuery> query) {
        this.name = name;
        this.desc = desc;
        this.implClass = query;
    }

    public static DatabaseType getType(String dbType) {
        DatabaseType[] dts;
        for (DatabaseType dt : dts = DatabaseType.values()) {
            if (!dt.getName().equalsIgnoreCase(dbType)) continue;
            return dt;
        }
        return OTHER;
    }

    public static DatabaseType getDbType(String jdbcUrl) {
        if (jdbcUrl.contains(":Cache:")) {
            return CACHEDB;
        }
        if (jdbcUrl.contains(":db2:")) {
            return DB2;
        }
        if (jdbcUrl.contains(":h2:")) {
            return H2;
        }
        if (jdbcUrl.contains(":mariadb:")) {
            return MARIADB;
        }
        if (jdbcUrl.contains(":mysql:") || jdbcUrl.contains(":cobar:")) {
            return MYSQL;
        }
        if (jdbcUrl.contains(":oracle:")) {
            return ORACLE;
        }
        if (jdbcUrl.contains(":postgresql:")) {
            return POSTGRE_SQL;
        }
        if (jdbcUrl.contains(":sqlserver:") || jdbcUrl.contains(":microsoft:")) {
            return SQL_SERVER2005;
        }
        if (jdbcUrl.contains(":sqlserver2012:")) {
            return SQL_SERVER;
        }
        return OTHER;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Class<? extends DatabaseQuery> getImplClass() {
        return this.implClass;
    }
}

