/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.Config;
import org.aoju.bus.shade.screw.engine.EngineFileType;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.ColumnSchema;
import org.aoju.bus.shade.screw.metadata.DataSchema;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;
import org.aoju.bus.shade.screw.metadata.Table;
import org.aoju.bus.shade.screw.metadata.TableSchema;
import org.aoju.bus.shade.screw.process.Process;
import org.aoju.bus.shade.screw.process.ProcessConfig;

public abstract class AbstractProcess
implements Process {
    protected Config config;
    volatile Map<String, List<? extends Table>> tablesCaching = new ConcurrentHashMap<String, List<? extends Table>>();
    volatile Map<String, List<Column>> columnsCaching = new ConcurrentHashMap<String, List<Column>>();
    volatile Map<String, List<PrimaryKey>> primaryKeysCaching = new ConcurrentHashMap<String, List<PrimaryKey>>();

    private AbstractProcess() {
    }

    AbstractProcess(Config config) {
        Assert.notNull((Object)config, (String)"Configuration can not be empty!", (Object[])new Object[0]);
        this.config = config;
    }

    protected List<TableSchema> filterTables(List<TableSchema> tables) {
        ProcessConfig produceConfig = this.config.getProduceConfig();
        if (!Objects.isNull(this.config) && !Objects.isNull(this.config.getProduceConfig())) {
            if (CollKit.isNotEmpty(produceConfig.getDesignatedTableName()) || CollKit.isNotEmpty(produceConfig.getDesignatedTablePrefix()) || CollKit.isNotEmpty(produceConfig.getDesignatedTableSuffix())) {
                return this.handleDesignated(tables);
            }
            return this.handleIgnore(tables);
        }
        return tables;
    }

    private List<TableSchema> handleDesignated(List<TableSchema> tables) {
        ArrayList<TableSchema> tableSchemas = new ArrayList<TableSchema>();
        ProcessConfig produceConfig = this.config.getProduceConfig();
        if (!Objects.isNull(this.config) && !Objects.isNull(produceConfig)) {
            List<String> list;
            if (CollKit.isNotEmpty(produceConfig.getDesignatedTableName())) {
                list = produceConfig.getDesignatedTableName();
                for (String name : list) {
                    tableSchemas.addAll(tables.stream().filter(j -> j.getTableName().equals(name)).collect(Collectors.toList()));
                }
            }
            if (CollKit.isNotEmpty(produceConfig.getDesignatedTablePrefix())) {
                list = produceConfig.getDesignatedTablePrefix();
                for (String prefix : list) {
                    tableSchemas.addAll(tables.stream().filter(j -> j.getTableName().startsWith(prefix)).collect(Collectors.toList()));
                }
            }
            if (CollKit.isNotEmpty(produceConfig.getDesignatedTableSuffix())) {
                list = produceConfig.getDesignatedTableSuffix();
                for (String suffix : list) {
                    tableSchemas.addAll(tables.stream().filter(j -> j.getTableName().endsWith(suffix)).collect(Collectors.toList()));
                }
            }
            return tableSchemas;
        }
        return tableSchemas;
    }

    private List<TableSchema> handleIgnore(List<TableSchema> tables) {
        ProcessConfig produceConfig = this.config.getProduceConfig();
        if (!Objects.isNull(this.config) && !Objects.isNull(produceConfig)) {
            List<String> list;
            if (CollKit.isNotEmpty(produceConfig.getIgnoreTableName())) {
                list = produceConfig.getIgnoreTableName();
                for (String name : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().equals(name)).collect(Collectors.toList());
                }
            }
            if (CollKit.isNotEmpty(produceConfig.getIgnoreTablePrefix())) {
                list = produceConfig.getIgnoreTablePrefix();
                for (String prefix : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().startsWith(prefix)).collect(Collectors.toList());
                }
            }
            if (CollKit.isNotEmpty(produceConfig.getIgnoreTableSuffix())) {
                list = produceConfig.getIgnoreTableSuffix();
                for (String suffix : list) {
                    tables = tables.stream().filter(j -> !j.getTableName().endsWith(suffix)).collect(Collectors.toList());
                }
            }
            return tables;
        }
        return tables;
    }

    public void optimizeData(DataSchema dataModel) {
        BeanKit.trimStrFields((Object)dataModel, (String[])new String[0]);
        List<TableSchema> tables = dataModel.getTables();
        tables.forEach(i -> {
            BeanKit.trimStrFields((Object)i, (String[])new String[0]);
            List<ColumnSchema> columns = i.getColumns();
            columns.forEach(x$0 -> BeanKit.trimStrFields((Object)x$0, (String[])new String[0]));
        });
        if (this.config.getEngineConfig().getFileType().equals(EngineFileType.WORD)) {
            BeanKit.trimAllFields((Object)dataModel);
            tables.forEach(i -> {
                BeanKit.trimAllFields((Object)i);
                List<ColumnSchema> columns = i.getColumns();
                columns.forEach(BeanKit::trimAllFields);
            });
        }
        if (this.config.getEngineConfig().getFileType().equals(EngineFileType.MD)) {
            BeanKit.replaceStrFields((Object)dataModel);
            tables.forEach(i -> {
                BeanKit.replaceStrFields((Object)i);
                List<ColumnSchema> columns = i.getColumns();
                columns.forEach(BeanKit::replaceStrFields);
            });
        }
    }
}

