/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.process;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.shade.screw.Config;
import org.aoju.bus.shade.screw.dialect.DatabaseQuery;
import org.aoju.bus.shade.screw.dialect.DatabaseQueryFactory;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.ColumnSchema;
import org.aoju.bus.shade.screw.metadata.DataSchema;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;
import org.aoju.bus.shade.screw.metadata.Table;
import org.aoju.bus.shade.screw.metadata.TableSchema;
import org.aoju.bus.shade.screw.process.AbstractProcess;

public class DataModelProcess
extends AbstractProcess {
    public DataModelProcess(Config config) {
        super(config);
    }

    @Override
    public DataSchema process() {
        DatabaseQuery query = new DatabaseQueryFactory(this.config.getDataSource()).newInstance();
        DataSchema model = new DataSchema();
        model.setTitle(this.config.getTitle());
        model.setOrganization(this.config.getOrganization());
        model.setOrganizationUrl(this.config.getOrganizationUrl());
        model.setVersion(this.config.getVersion());
        model.setDescription(this.config.getDescription());
        long start = System.currentTimeMillis();
        Database database = query.getDataBase();
        Logger.debug((String)"query the database time consuming:{}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        model.setDatabase(database.getDatabase());
        start = System.currentTimeMillis();
        List<? extends Table> tables = query.getTables();
        Logger.debug((String)"query the table time consuming:{}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        List<? extends Column> columns = query.getTableColumns();
        Logger.debug((String)"query the column time consuming:{}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        List<? extends PrimaryKey> primaryKeys = query.getPrimaryKeys();
        Logger.debug((String)"query the primary key time consuming:{}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        start = System.currentTimeMillis();
        ArrayList<TableSchema> tableSchemas = new ArrayList<TableSchema>();
        this.tablesCaching.put(database.getDatabase(), tables);
        for (Table table : tables) {
            this.columnsCaching.put(table.getTableName(), columns.stream().filter(i -> i.getTableName().equals(table.getTableName())).collect(Collectors.toList()));
            this.primaryKeysCaching.put(table.getTableName(), primaryKeys.stream().filter(i -> i.getTableName().equals(table.getTableName())).collect(Collectors.toList()));
        }
        for (Table table : tables) {
            TableSchema tableSchema = new TableSchema();
            tableSchema.setTableName(table.getTableName());
            tableSchema.setRemarks(table.getRemarks());
            tableSchemas.add(tableSchema);
            ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
            List<String> key = ((List)this.primaryKeysCaching.get(table.getTableName())).stream().map(PrimaryKey::getColumnName).collect(Collectors.toList());
            for (Column column : (List)this.columnsCaching.get(table.getTableName())) {
                this.packageColumn(columnSchemas, key, column);
            }
            tableSchema.setColumns(columnSchemas);
        }
        model.setTables(this.filterTables(tableSchemas));
        this.optimizeData(model);
        Logger.debug((String)"encapsulation processing data time consuming:{}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        return model;
    }

    private void packageColumn(List<ColumnSchema> columnSchemas, List<String> keyList, Column column) {
        ColumnSchema columnSchema = new ColumnSchema();
        columnSchema.setOrdinalPosition(column.getOrdinalPosition());
        columnSchema.setColumnName(column.getColumnName());
        columnSchema.setColumnType(column.getColumnType());
        columnSchema.setTypeName(column.getTypeName());
        columnSchema.setColumnLength(column.getColumnLength());
        columnSchema.setColumnLength(column.getColumnLength());
        columnSchema.setColumnSize(column.getColumnSize());
        columnSchema.setDecimalDigits((String)ObjectKit.defaultIfEmpty((CharSequence)column.getDecimalDigits(), (CharSequence)"0"));
        columnSchema.setNullable("0".equals(column.getNullable()) ? "N" : "Y");
        columnSchema.setPrimaryKey(keyList.contains(column.getColumnName()) ? "Y" : "N");
        columnSchema.setColumnDef(column.getColumnDef());
        columnSchema.setRemarks(column.getRemarks());
        columnSchemas.add(columnSchema);
    }
}

