/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.shade.screw.dialect.DatabaseQuery;
import org.aoju.bus.shade.screw.dialect.DatabaseType;

public class DatabaseQueryFactory
implements Serializable {
    private DataSource dataSource;

    private DatabaseQueryFactory() {
    }

    public DatabaseQueryFactory(DataSource source) {
        this.dataSource = source;
    }

    public DatabaseQuery newInstance() {
        try {
            String url = this.getDataSource().getConnection().getMetaData().getURL();
            Class<? extends DatabaseQuery> query = DatabaseType.getDbType(url).getImplClass();
            Constructor<? extends DatabaseQuery> constructor = query.getConstructor(DataSource.class);
            return constructor.newInstance(this.dataSource);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseQueryFactory)) {
            return false;
        }
        DatabaseQueryFactory other = (DatabaseQueryFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseQueryFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseQueryFactory(dataSource=" + this.getDataSource() + ")";
    }
}

