/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.Complex;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.boot.BootDecryptorProvider;
import org.aoju.bus.shade.safety.boot.BootEncryptorProvider;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;
import org.aoju.bus.shade.safety.provider.JdkDecryptorProvider;
import org.aoju.bus.shade.safety.provider.JdkEncryptorProvider;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class Boot {
    public static void encrypt(String src, String dest, Key key) throws Exception {
        Boot.encrypt(new File(src), new File(dest), key);
    }

    public static void encrypt(String src, String dest, Key key, int mode) throws Exception {
        Boot.encrypt(new File(src), new File(dest), key, mode);
    }

    public static void encrypt(File src, File dest, Key key) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.encrypt((InputStream)in, (OutputStream)out, key);
        }
    }

    public static void encrypt(File src, File dest, Key key, int mode) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.encrypt((InputStream)in, (OutputStream)out, key, mode);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, Key key) throws Exception {
        BootEncryptorProvider xBootEncryptor = new BootEncryptorProvider(new JdkEncryptorProvider(key.getAlgorithm()));
        xBootEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(InputStream in, OutputStream out, Key key, int mode) throws Exception {
        BootEncryptorProvider xBootEncryptor = new BootEncryptorProvider((EncryptorProvider)new JdkEncryptorProvider(key.getAlgorithm()), 8, mode);
        xBootEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(String src, String dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(new File(src), new File(dest), key, filter);
    }

    public static void encrypt(String src, String dest, Key key, int mode, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(new File(src), new File(dest), key, mode, filter);
    }

    public static void encrypt(File src, File dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.encrypt((InputStream)in, (OutputStream)out, key, filter);
        }
    }

    public static void encrypt(File src, File dest, Key key, int mode, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.encrypt((InputStream)in, (OutputStream)out, key, mode, filter);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        BootEncryptorProvider xBootEncryptor = new BootEncryptorProvider((EncryptorProvider)new JdkEncryptorProvider(key.getAlgorithm()), filter);
        xBootEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(InputStream in, OutputStream out, Key key, int mode, Complex<JarArchiveEntry> filter) throws Exception {
        BootEncryptorProvider xBootEncryptor = new BootEncryptorProvider(new JdkEncryptorProvider(key.getAlgorithm()), 8, mode, filter);
        xBootEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(String src, String dest, String password) throws Exception {
        Boot.encrypt(src, dest, password, Algorithm.AES.getValue());
    }

    public static void encrypt(String src, String dest, String password, String algorithm) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        Boot.encrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize);
    }

    public static void encrypt(File src, File dest, String password) throws Exception {
        Boot.encrypt(src, dest, password, Algorithm.AES.getValue());
    }

    public static void encrypt(File src, File dest, String password, String algorithm) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.encrypt((InputStream)in, (OutputStream)out, password, algorithm, keysize, ivsize);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, String password) throws Exception {
        Boot.encrypt(in, out, password, Algorithm.AES.getValue());
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm) throws Exception {
        Boot.encrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize) throws Exception {
        Boot.encrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize) throws Exception {
        BootEncryptorProvider xBootEncryptor = new BootEncryptorProvider(new JdkEncryptorProvider(algorithm));
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xBootEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(String src, String dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(src, dest, password, Algorithm.AES.getValue(), filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize, filter);
    }

    public static void encrypt(File src, File dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(src, dest, password, Algorithm.AES.getValue(), filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.encrypt(in, out, password, algorithm, keysize, ivsize, filter);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(in, out, password, Algorithm.AES.getValue(), filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.encrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        BootEncryptorProvider xBootEncryptor = new BootEncryptorProvider((EncryptorProvider)new JdkEncryptorProvider(algorithm), filter);
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xBootEncryptor.encrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, Key key) throws Exception {
        Boot.decrypt(new File(src), new File(dest), key);
    }

    public static void decrypt(File src, File dest, Key key) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.decrypt((InputStream)in, (OutputStream)out, key);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, Key key) throws Exception {
        BootDecryptorProvider xBootDecryptor = new BootDecryptorProvider(new JdkDecryptorProvider(key.getAlgorithm()));
        xBootDecryptor.decrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(new File(src), new File(dest), key, filter);
    }

    public static void decrypt(File src, File dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.decrypt((InputStream)in, (OutputStream)out, key, filter);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        BootDecryptorProvider xBootDecryptor = new BootDecryptorProvider((DecryptorProvider)new JdkDecryptorProvider(key.getAlgorithm()), filter);
        xBootDecryptor.decrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, String password) throws Exception {
        Boot.decrypt(src, dest, password, Algorithm.AES.getValue());
    }

    public static void decrypt(String src, String dest, String password, String algorithm) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        Boot.decrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize);
    }

    public static void decrypt(File src, File dest, String password) throws Exception {
        Boot.decrypt(src, dest, password, Algorithm.AES.getValue());
    }

    public static void decrypt(File src, File dest, String password, String algorithm) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.decrypt((InputStream)in, (OutputStream)out, password, algorithm, keysize, ivsize);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String password) throws Exception {
        Boot.decrypt(in, out, password, Algorithm.AES.getValue());
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm) throws Exception {
        Boot.decrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize) throws Exception {
        Boot.decrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize) throws Exception {
        BootDecryptorProvider xBootDecryptor = new BootDecryptorProvider(new JdkDecryptorProvider(algorithm));
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xBootDecryptor.decrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(src, dest, password, Algorithm.AES.getValue(), filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize, filter);
    }

    public static void decrypt(File src, File dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(src, dest, password, Algorithm.AES.getValue(), filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Boot.decrypt(in, out, password, algorithm, keysize, ivsize, filter);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(in, out, password, Algorithm.AES.getValue(), filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Boot.decrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        BootDecryptorProvider xBootDecryptor = new BootDecryptorProvider((DecryptorProvider)new JdkDecryptorProvider(algorithm), filter);
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xBootDecryptor.decrypt(key, in, out);
    }
}

