/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.Complex;
import org.aoju.bus.shade.safety.Injector;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.boot.BootJarArchiveEntry;
import org.aoju.bus.shade.safety.boot.jar.JarAllComplex;
import org.aoju.bus.shade.safety.boot.jar.JarEncryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;
import org.aoju.bus.shade.safety.provider.EntryEncryptorProvider;
import org.aoju.bus.shade.safety.streams.AlwaysInputStream;
import org.aoju.bus.shade.safety.streams.AlwaysOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class BootEncryptorProvider
extends EntryEncryptorProvider<JarArchiveEntry>
implements EncryptorProvider {
    private static final Map<String, String> map = new HashMap<String, String>();
    private final int level;
    private final int mode;

    public BootEncryptorProvider(EncryptorProvider encryptorProvider) {
        this(encryptorProvider, new JarAllComplex());
    }

    public BootEncryptorProvider(EncryptorProvider encryptorProvider, Complex<JarArchiveEntry> filter) {
        this(encryptorProvider, 8, filter);
    }

    public BootEncryptorProvider(EncryptorProvider encryptorProvider, int level) {
        this(encryptorProvider, level, new JarAllComplex());
    }

    public BootEncryptorProvider(EncryptorProvider encryptorProvider, int level, Complex<JarArchiveEntry> filter) {
        this(encryptorProvider, level, Builder.MODE_NORMAL, filter);
    }

    public BootEncryptorProvider(EncryptorProvider encryptorProvider, int level, int mode) {
        this(encryptorProvider, level, mode, new JarAllComplex());
    }

    public BootEncryptorProvider(EncryptorProvider encryptorProvider, int level, int mode, Complex<JarArchiveEntry> filter) {
        super(encryptorProvider, filter);
        this.level = level;
        this.mode = mode;
    }

    @Override
    public void encrypt(Key key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.encrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(Key key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        LinkedHashSet<String> indexes = new LinkedHashSet<String>();
        try {
            String mainClass;
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            AlwaysInputStream nis = new AlwaysInputStream((InputStream)zis);
            AlwaysOutputStream nos = new AlwaysOutputStream((OutputStream)zos);
            JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider(this.encryptorProvider, this.level, this.filter);
            Manifest manifest = null;
            while (null != (entry = zis.getNextJarEntry())) {
                JarArchiveEntry jarArchiveEntry;
                if (entry.getName().startsWith(Builder.XJAR_SRC_DIR) || entry.getName().endsWith("META-INF/") || entry.getName().endsWith("META-INF/FOREST.MF")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass2 = attributes.getValue("Main-Class");
                    if (null != mainClass2) {
                        attributes.putValue("Boot-Main-Class", mainClass2);
                        attributes.putValue("Main-Class", map.get(mainClass2));
                    }
                    if ((this.mode & Builder.FLAG_DANGER) == Builder.FLAG_DANGER) {
                        Builder.retainKey(key, attributes);
                    }
                    JarArchiveEntry jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    manifest.write(nos);
                } else if (entry.getName().startsWith("BOOT-INF/classes/")) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    BootJarArchiveEntry bootJarArchiveEntry = new BootJarArchiveEntry((ZipArchiveEntry)entry);
                    boolean filtered = this.on(bootJarArchiveEntry);
                    if (filtered) {
                        indexes.add(bootJarArchiveEntry.getName());
                    }
                    EncryptorProvider encryptor = filtered ? this.encryptorProvider : this.xNopEncryptor;
                    try (OutputStream eos = encryptor.encrypt(key, nos);){
                        Builder.transfer((InputStream)nis, eos);
                    }
                } else if (entry.getName().startsWith("BOOT-INF/lib/")) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    CheckedOutputStream cos = new CheckedOutputStream(bos, new CRC32());
                    xJarEncryptor.encrypt(key, nis, cos);
                    JarArchiveEntry jar = new JarArchiveEntry(entry.getName());
                    jar.setMethod(0);
                    jar.setSize((long)bos.size());
                    jar.setTime(entry.getTime());
                    jar.setCrc(cos.getChecksum().getValue());
                    zos.putArchiveEntry((ArchiveEntry)jar);
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    Builder.transfer((InputStream)bis, nos);
                } else {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    Builder.transfer((InputStream)nis, nos);
                }
                zos.closeArchiveEntry();
            }
            if (!indexes.isEmpty()) {
                JarArchiveEntry xjarInfDir = new JarArchiveEntry("BOOT-INF/classes/META-INF/");
                xjarInfDir.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfDir);
                zos.closeArchiveEntry();
                JarArchiveEntry xjarInfIdx = new JarArchiveEntry("BOOT-INF/classes/META-INF/FOREST.MF");
                xjarInfIdx.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xjarInfIdx);
                for (String index : indexes) {
                    zos.write(index.getBytes());
                    zos.write(Builder.CRLF.getBytes());
                }
                zos.closeArchiveEntry();
            }
            String string = mainClass = null != manifest && null != manifest.getMainAttributes() ? manifest.getMainAttributes().getValue("Main-Class") : null;
            if (null != mainClass) {
                Injector.inject(zos);
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            Builder.close(zis);
            Builder.close(zos);
            throw throwable;
        }
        Builder.close((Closeable)zis);
        Builder.close((Closeable)zos);
    }

    static {
        map.put("org.springframework.boot.loader.JarLauncher", "org.aoju.bus.shade.safety.boot.BootJarLauncher");
        map.put("org.springframework.boot.loader.WarLauncher", "org.aoju.bus.shade.safety.boot.BootWarLauncher");
        map.put("org.springframework.boot.loader.PropertiesLauncher", "org.aoju.bus.shade.safety.boot.BootPropertiesLauncher");
    }
}

