/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.loader.Loaders;
import org.aoju.bus.shade.safety.Builder;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;

public class Injector {
    public static void inject(JarArchiveOutputStream zos) throws IOException {
        HashSet<String> directories = new HashSet<String>();
        Enumeration resources = Loaders.ant().load(Builder.XJAR_SRC_DIR + "**");
        while (resources.hasMoreElements()) {
            Resource resource = (Resource)resources.nextElement();
            String name = resource.getName();
            String directory = name.substring(0, name.lastIndexOf("/") + 1);
            if (directories.add(directory)) {
                JarArchiveEntry xDirEntry = new JarArchiveEntry(directory);
                xDirEntry.setTime(System.currentTimeMillis());
                zos.putArchiveEntry((ArchiveEntry)xDirEntry);
                zos.closeArchiveEntry();
            }
            JarArchiveEntry xJarEntry = new JarArchiveEntry(name);
            xJarEntry.setTime(System.currentTimeMillis());
            zos.putArchiveEntry((ArchiveEntry)xJarEntry);
            try (InputStream ris = resource.getStream();){
                Builder.transfer(ris, (OutputStream)zos);
            }
            zos.closeArchiveEntry();
        }
    }
}

