/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.boot.BootURLHandler;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;
import org.springframework.boot.loader.LaunchedURLClassLoader;

public class BootClassLoader
extends LaunchedURLClassLoader {
    private final BootURLHandler bootURLHandler;

    public BootClassLoader(URL[] urls, ClassLoader parent, DecryptorProvider decryptorProvider, EncryptorProvider encryptorProvider, Key key) throws Exception {
        super(urls, parent);
        this.bootURLHandler = new BootURLHandler(decryptorProvider, encryptorProvider, key, (ClassLoader)((Object)this));
    }

    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (null == url) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)this.bootURLHandler));
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration enumeration = super.findResources(name);
        if (null == enumeration) {
            return null;
        }
        return new XBootEnumeration(enumeration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            URL resource = this.findResource(name.replace('.', '/') + ".class");
            if (null == resource) {
                throw new ClassNotFoundException(name, e);
            }
            try (InputStream in = resource.openStream();){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Builder.transfer(in, bos);
                byte[] bytes = bos.toByteArray();
                Class clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            catch (Throwable t) {
                throw new ClassNotFoundException(name, t);
            }
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class XBootEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> enumeration;

        XBootEnumeration(Enumeration<URL> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL url = this.enumeration.nextElement();
            if (null == url) {
                return null;
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), (URLStreamHandler)((Object)BootClassLoader.this.bootURLHandler));
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
    }
}

