/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;
import org.aoju.bus.shade.safety.provider.JdkDecryptorProvider;
import org.aoju.bus.shade.safety.provider.JdkEncryptorProvider;

public class Launcher {
    public final String[] args;
    public final DecryptorProvider decryptorProvider;
    public final EncryptorProvider encryptorProvider;
    public final Key key;

    public Launcher(String ... args) throws Exception {
        Throwable throwable;
        Object in;
        File file;
        String path;
        String filepath;
        this.args = args;
        String algorithm = "AES";
        int keysize = Builder.DEFAULT_KEYSIZE;
        int ivsize = Builder.DEFAULT_IVSIZE;
        String password = null;
        String keypath = null;
        for (String arg : args) {
            if (arg.toLowerCase().startsWith("--xjar.algorithm=")) {
                algorithm = arg.substring("--xjar.algorithm=".length());
            }
            if (arg.toLowerCase().startsWith("--xjar.keysize=")) {
                keysize = Integer.valueOf(arg.substring("--xjar.keysize=".length()));
            }
            if (arg.toLowerCase().startsWith("--xjar.ivsize=")) {
                ivsize = Integer.valueOf(arg.substring("--xjar.ivsize=".length()));
            }
            if (arg.toLowerCase().startsWith("--xjar.password=")) {
                password = arg.substring("--xjar.password=".length());
            }
            if (!arg.toLowerCase().startsWith("--xjar.keyfile=")) continue;
            keypath = arg.substring("--xjar.keyfile=".length());
        }
        ProtectionDomain domain = this.getClass().getProtectionDomain();
        CodeSource source = domain.getCodeSource();
        URI location = null == source ? null : source.getLocation().toURI();
        String string = filepath = null == location ? null : location.getSchemeSpecificPart();
        if (null != filepath) {
            File file2 = new File(filepath);
            JarFile jar = new JarFile(file2, false);
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            if (null != attributes.getValue("Jar-Algorithm")) {
                algorithm = attributes.getValue("Jar-Algorithm");
            }
            if (null != attributes.getValue("Jar-Keysize")) {
                keysize = Integer.valueOf(attributes.getValue("Jar-Keysize"));
            }
            if (null != attributes.getValue("Jar-Ivsize")) {
                ivsize = Integer.valueOf(attributes.getValue("Jar-Ivsize"));
            }
            if (null != attributes.getValue("Jar-Password")) {
                password = attributes.getValue("Jar-Password");
            }
        }
        Properties key = null;
        File keyfile = null;
        if (null != keypath) {
            path = Builder.absolutize(keypath);
            file = new File(path);
            if (file.exists() && file.isFile()) {
                keyfile = file;
                in = new FileInputStream(file);
                throwable = null;
                try {
                    key = new Properties();
                    key.load((InputStream)in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((InputStream)in).close();
                        }
                    }
                }
            }
            throw new FileNotFoundException("could not find key file at path: " + file.getCanonicalPath());
        }
        path = Builder.absolutize("xjar.key");
        file = new File(path);
        if (file.exists() && file.isFile()) {
            keyfile = file;
            in = new FileInputStream(file);
            throwable = null;
            try {
                key = new Properties();
                key.load((InputStream)in);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        String hold = null;
        if (null != key) {
            Set<String> names = key.stringPropertyNames();
            for (String name : names) {
                switch (name.toLowerCase()) {
                    case "algorithm": {
                        algorithm = key.getProperty(name);
                        break;
                    }
                    case "keysize": {
                        keysize = Integer.valueOf(key.getProperty(name));
                        break;
                    }
                    case "ivsize": {
                        ivsize = Integer.valueOf(key.getProperty(name));
                        break;
                    }
                    case "password": {
                        password = key.getProperty(name);
                        break;
                    }
                    case "hold": {
                        hold = key.getProperty(name);
                    }
                }
            }
        }
        if ((null == hold || !Arrays.asList("true", "1", "yes", "y").contains(hold.trim().toLowerCase())) && null != keyfile && keyfile.exists() && !keyfile.delete() && keyfile.exists()) {
            throw new IOException("could not delete key file : " + keyfile.getCanonicalPath());
        }
        if (null == password && null != System.console()) {
            Console console = System.console();
            char[] chars = console.readPassword("password:", new Object[0]);
            password = new String(chars);
        }
        if (null == password) {
            Scanner scanner = new Scanner(System.in);
            password = scanner.nextLine();
        }
        this.decryptorProvider = new JdkDecryptorProvider(algorithm);
        this.encryptorProvider = new JdkEncryptorProvider(algorithm);
        this.key = Builder.key(algorithm, keysize, ivsize, password);
    }
}

