/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot.jar;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.aoju.bus.shade.safety.Launcher;
import org.aoju.bus.shade.safety.boot.jar.JarClassLoader;

public class JarLauncher {
    private final Launcher launcher;

    public JarLauncher(String ... args) throws Exception {
        this.launcher = new Launcher(args);
    }

    public static void main(String ... args) throws Exception {
        new JarLauncher(args).launch();
    }

    public void launch() throws Exception {
        JarClassLoader jarClassLoader;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            jarClassLoader = new JarClassLoader(urlClassLoader.getURLs(), classLoader.getParent(), this.launcher.decryptorProvider, this.launcher.encryptorProvider, this.launcher.key);
        } else {
            String path;
            ProtectionDomain domain = this.getClass().getProtectionDomain();
            CodeSource source = domain.getCodeSource();
            URI location = null == source ? null : source.getLocation().toURI();
            String string = path = null == location ? null : location.getSchemeSpecificPart();
            if (null == path) {
                throw new IllegalStateException("Unable to determine code source archive");
            }
            File jar = new File(path);
            URL url = jar.toURI().toURL();
            jarClassLoader = new JarClassLoader(new URL[]{url}, classLoader.getParent(), this.launcher.decryptorProvider, this.launcher.encryptorProvider, this.launcher.key);
        }
        Thread.currentThread().setContextClassLoader(jarClassLoader);
        URL resource = jarClassLoader.findResource("META-INF/MANIFEST.MF");
        try (InputStream in = resource.openStream();){
            Manifest manifest = new Manifest(in);
            Attributes attributes = manifest.getMainAttributes();
            String jarMainClass = attributes.getValue("Jar-Main-Class");
            Class<?> mainClass = jarClassLoader.loadClass(jarMainClass);
            Method mainMethod = mainClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{this.launcher.args});
        }
    }
}

