/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect.cachedb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.screw.dialect.AbstractDatabaseQuery;
import org.aoju.bus.shade.screw.dialect.cachedb.CacheDbColumn;
import org.aoju.bus.shade.screw.dialect.cachedb.CacheDbDatabase;
import org.aoju.bus.shade.screw.dialect.cachedb.CacheDbPrimaryKey;
import org.aoju.bus.shade.screw.dialect.cachedb.CacheDbTable;
import org.aoju.bus.shade.screw.mapping.Mapping;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;
import org.aoju.bus.shade.screw.metadata.Table;

public class CacheDbDataBaseQuery
extends AbstractDatabaseQuery {
    public CacheDbDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws InstrumentException {
        CacheDbDatabase model = new CacheDbDatabase();
        model.setDatabase(this.getSchema());
        return model;
    }

    @Override
    public List<? extends Table> getTables() throws InstrumentException {
        List<CacheDbTable> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), null, new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, CacheDbTable.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                CacheDbDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        CacheDbDataBaseQuery.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns(String table) throws InstrumentException {
        List<CacheDbColumn> list;
        Assert.notEmpty((CharSequence)table, (String)"Table name can not be empty!", (Object[])new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<CacheDbColumn> list2 = Mapping.convertList(resultSet, CacheDbColumn.class);
            List<String> tableNames = list2.stream().map(CacheDbColumn::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollKit.isEmpty((Map)this.columnsCaching)) {
                if (table.equals("%")) {
                    sql = MessageFormat.format("select TABLE_NAME as \"TABLE_NAME\",COLUMN_NAME as \"COLUMN_NAME\",DESCRIPTION as \"REMARKS\",case when CHARACTER_MAXIMUM_LENGTH is null then DATA_TYPE  || '''' else DATA_TYPE  || ''(''||CHARACTER_MAXIMUM_LENGTH ||'')'' end as \"COLUMN_TYPE\" from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''{0}''", this.getSchema());
                    PreparedStatement statement = this.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = MessageFormat.format("select TABLE_NAME as \"TABLE_NAME\",COLUMN_NAME as \"COLUMN_NAME\",DESCRIPTION as \"REMARKS\",case when CHARACTER_MAXIMUM_LENGTH is null then DATA_TYPE  || ''''else DATA_TYPE  || ''(''||CHARACTER_MAXIMUM_LENGTH ||'')'' end as \"COLUMN_TYPE\" from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''{0}'' and TABLE_NAME = ''{1}''", this.getSchema(), table);
                    resultSet = this.prepareStatement(sql).executeQuery();
                }
                List<CacheDbColumn> inquires = Mapping.convertList(resultSet, CacheDbColumn.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setColumnType(j.getColumnType());
                        i.setColumnLength(j.getColumnLength());
                        i.setRemarks(j.getRemarks());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                CacheDbDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        CacheDbDataBaseQuery.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws InstrumentException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws InstrumentException {
        List<CacheDbPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, CacheDbPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                CacheDbDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        CacheDbDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InstrumentException {
        List<CacheDbPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            String sql = "select TABLE_CATALOG ,TABLE_NAME as \"TABLE_NAME\",TABLE_SCHEMA as \"TABLE_SCHEM\",COLUMN_NAME as \"COLUMN_NAME\",ORDINAL_POSITION as \"KEY_SEQ\" from INFORMATION_SCHEMA.COLUMNS where PRIMARY_KEY='YES' and TABLE_SCHEMA='%s'";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertList(resultSet, CacheDbPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                CacheDbDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        CacheDbDataBaseQuery.close(resultSet);
        return list;
    }
}

