/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect.sqlserver;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.screw.dialect.AbstractDatabaseQuery;
import org.aoju.bus.shade.screw.dialect.sqlserver.SqlServerColumn;
import org.aoju.bus.shade.screw.dialect.sqlserver.SqlServerDatabase;
import org.aoju.bus.shade.screw.dialect.sqlserver.SqlServerPrimaryKey;
import org.aoju.bus.shade.screw.dialect.sqlserver.SqlServerTable;
import org.aoju.bus.shade.screw.mapping.Mapping;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;

public class SqlServerDataBaseQuery
extends AbstractDatabaseQuery {
    public SqlServerDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws InstrumentException {
        SqlServerDatabase model = new SqlServerDatabase();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<SqlServerTable> getTables() {
        List<SqlServerTable> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            List<SqlServerTable> list2 = Mapping.convertList(resultSet, SqlServerTable.class);
            String sql = "select cast(so.name as varchar(500)) as TABLE_NAME, cast(sep.value as varchar(500)) as REMARKS from sysobjects so left JOIN sys.extended_properties sep on sep.major_id = so.id and sep.minor_id = 0 where (xtype = 'U' or xtype = 'v')";
            resultSet = this.prepareStatement(String.format(sql, this.getCatalog())).executeQuery();
            List<SqlServerTable> inquires = Mapping.convertList(resultSet, SqlServerTable.class);
            for (SqlServerTable model : list2) {
                for (SqlServerTable inquire : inquires) {
                    if (!model.getTableName().equals(inquire.getTableName())) continue;
                    model.setRemarks(inquire.getRemarks());
                }
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlServerDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        SqlServerDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    public List<SqlServerColumn> getTableColumns(String table) throws InstrumentException {
        List<SqlServerColumn> list;
        Assert.notEmpty((CharSequence)table, (String)"Table name can not be empty!", (Object[])new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<SqlServerColumn> list2 = Mapping.convertList(resultSet, SqlServerColumn.class);
            List<String> tableNames = list2.stream().map(SqlServerColumn::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollKit.isEmpty((Map)this.columnsCaching)) {
                if (table.equals("%")) {
                    sql = "SELECT cast(a.name AS VARCHAR(500)) AS TABLE_NAME, cast(b.name AS VARCHAR(500)) AS COLUMN_NAME, cast(c.VALUE AS NVARCHAR(500)) AS REMARKS, cast(sys.types.name AS VARCHAR(500)) + '(' + cast(b.max_length AS NVARCHAR(500)) + ')' AS COLUMN_TYPE, cast(b.max_length AS NVARCHAR(500)) AS COLUMN_LENGTH FROM(SELECT name, object_id FROM sys.tables UNION all SELECT name, object_id FROM sys.views) a INNER JOIN sys.columns b ON b.object_id = a.object_id LEFT JOIN sys.types ON b.user_type_id = sys.types.user_type_id LEFT JOIN sys.extended_properties c ON c.major_id = b.object_id AND c.minor_id = b.column_id";
                    PreparedStatement statement = this.prepareStatement(sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT cast(a.name AS VARCHAR(500)) AS TABLE_NAME, cast(b.name AS VARCHAR(500)) AS COLUMN_NAME, cast(c.VALUE AS NVARCHAR(500)) AS REMARKS, cast(sys.types.name AS VARCHAR(500)) + '(' + cast(b.max_length AS NVARCHAR(500)) + ')' AS COLUMN_TYPE, cast(b.max_length AS NVARCHAR(500)) AS COLUMN_LENGTH FROM(SELECT name, object_id FROM sys.tables UNION all SELECT name, object_id FROM sys.views) a INNER JOIN sys.columns b ON b.object_id = a.object_id LEFT JOIN sys.types ON b.user_type_id = sys.types.user_type_id LEFT JOIN sys.extended_properties c ON c.major_id = b.object_id AND c.minor_id = b.column_id WHERE a.name = '%s'";
                    resultSet = this.prepareStatement(String.format(sql, table)).executeQuery();
                }
                List<SqlServerColumn> inquires = Mapping.convertList(resultSet, SqlServerColumn.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setRemarks(j.getRemarks());
                        i.setColumnLength(j.getColumnLength());
                        i.setColumnType(j.getColumnType());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlServerDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        SqlServerDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws InstrumentException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws InstrumentException {
        List<SqlServerPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, SqlServerPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlServerDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        SqlServerDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InstrumentException {
        List<SqlServerPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT TABLE_CATALOG AS 'TABLE_QUALIFIER', TABLE_SCHEMA AS 'TABLE_OWNER', TABLE_NAME AS 'TABLE_NAME', COLUMN_NAME AS 'COLUMN_NAME', ORDINAL_POSITION AS 'KEY_SEQ', CONSTRAINT_NAME AS 'PK_NAME' FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE TABLE_CATALOG = '%s' AND TABLE_SCHEMA = '%s' ORDER BY KEY_SEQ";
            resultSet = this.prepareStatement(String.format(sql, this.getCatalog(), this.getSchema())).executeQuery();
            list = Mapping.convertList(resultSet, SqlServerPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InstrumentException((Throwable)e);
            }
            catch (Throwable throwable) {
                SqlServerDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        SqlServerDataBaseQuery.close(resultSet);
        return list;
    }
}

