/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.archive;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.Complex;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;
import org.aoju.bus.shade.safety.provider.EntryEncryptorProvider;
import org.aoju.bus.shade.safety.streams.AlwaysOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipEncryptorProvider
extends EntryEncryptorProvider<ZipArchiveEntry>
implements EncryptorProvider {
    private final int level;

    public ZipEncryptorProvider(EncryptorProvider encryptorProvider) {
        this(encryptorProvider, (Complex<ZipArchiveEntry>)null);
    }

    public ZipEncryptorProvider(EncryptorProvider encryptorProvider, Complex<ZipArchiveEntry> filter) {
        this(encryptorProvider, 8, filter);
    }

    public ZipEncryptorProvider(EncryptorProvider encryptorProvider, int level) {
        this(encryptorProvider, level, null);
    }

    public ZipEncryptorProvider(EncryptorProvider encryptorProvider, int level, Complex<ZipArchiveEntry> filter) {
        super(encryptorProvider, filter);
        this.level = level;
    }

    @Override
    public void encrypt(Key key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.encrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(Key key, InputStream in, OutputStream out) throws IOException {
        ZipArchiveInputStream zis = null;
        ZipArchiveOutputStream zos = null;
        try {
            ZipArchiveEntry entry;
            zis = new ZipArchiveInputStream(in);
            zos = new ZipArchiveOutputStream(out);
            zos.setLevel(this.level);
            AlwaysOutputStream nos = new AlwaysOutputStream((OutputStream)zos);
            while (null != (entry = zis.getNextZipEntry())) {
                if (entry.isDirectory()) continue;
                zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entry.getName()));
                EncryptorProvider encryptor = this.on(entry) ? this : this.xNopEncryptor;
                try (OutputStream eos = encryptor.encrypt(key, nos);){
                    Builder.transfer((InputStream)zis, eos);
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            Builder.close(zis);
            Builder.close(zos);
            throw throwable;
        }
        Builder.close((Closeable)zis);
        Builder.close((Closeable)zos);
    }
}

