/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;

public class BootURLConnection
extends JarURLConnection {
    private final JarURLConnection jarURLConnection;
    private final DecryptorProvider decryptorProvider;
    private final EncryptorProvider encryptorProvider;
    private final Key key;

    public BootURLConnection(JarURLConnection jarURLConnection, DecryptorProvider decryptorProvider, EncryptorProvider encryptorProvider, Key key) throws MalformedURLException {
        super(jarURLConnection.getURL());
        this.jarURLConnection = jarURLConnection;
        this.decryptorProvider = decryptorProvider;
        this.encryptorProvider = encryptorProvider;
        this.key = key;
    }

    @Override
    public void connect() throws IOException {
        this.jarURLConnection.connect();
    }

    @Override
    public int getConnectTimeout() {
        return this.jarURLConnection.getConnectTimeout();
    }

    @Override
    public void setConnectTimeout(int timeout) {
        this.jarURLConnection.setConnectTimeout(timeout);
    }

    @Override
    public int getReadTimeout() {
        return this.jarURLConnection.getReadTimeout();
    }

    @Override
    public void setReadTimeout(int timeout) {
        this.jarURLConnection.setReadTimeout(timeout);
    }

    @Override
    public URL getURL() {
        return this.jarURLConnection.getURL();
    }

    @Override
    public int getContentLength() {
        return this.jarURLConnection.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return this.jarURLConnection.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return this.jarURLConnection.getContentType();
    }

    @Override
    public String getContentEncoding() {
        return this.jarURLConnection.getContentEncoding();
    }

    @Override
    public long getExpiration() {
        return this.jarURLConnection.getExpiration();
    }

    @Override
    public long getDate() {
        return this.jarURLConnection.getDate();
    }

    @Override
    public long getLastModified() {
        return this.jarURLConnection.getLastModified();
    }

    @Override
    public String getHeaderField(String name) {
        return this.jarURLConnection.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.jarURLConnection.getHeaderFields();
    }

    @Override
    public int getHeaderFieldInt(String name, int Default) {
        return this.jarURLConnection.getHeaderFieldInt(name, Default);
    }

    @Override
    public long getHeaderFieldLong(String name, long Default) {
        return this.jarURLConnection.getHeaderFieldLong(name, Default);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        return this.jarURLConnection.getHeaderFieldDate(name, Default);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.jarURLConnection.getHeaderFieldKey(n);
    }

    @Override
    public String getHeaderField(int n) {
        return this.jarURLConnection.getHeaderField(n);
    }

    @Override
    public Object getContent() throws IOException {
        return this.jarURLConnection.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.jarURLConnection.getContent(classes);
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.jarURLConnection.getPermission();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = this.jarURLConnection.getInputStream();
        return this.decryptorProvider.decrypt(this.key, in);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream out = this.jarURLConnection.getOutputStream();
        return this.encryptorProvider.encrypt(this.key, out);
    }

    @Override
    public String toString() {
        return this.jarURLConnection.toString();
    }

    @Override
    public boolean getDoInput() {
        return this.jarURLConnection.getDoInput();
    }

    @Override
    public void setDoInput(boolean doInput) {
        this.jarURLConnection.setDoInput(doInput);
    }

    @Override
    public boolean getDoOutput() {
        return this.jarURLConnection.getDoOutput();
    }

    @Override
    public void setDoOutput(boolean doOutput) {
        this.jarURLConnection.setDoOutput(doOutput);
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.jarURLConnection.getAllowUserInteraction();
    }

    @Override
    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.jarURLConnection.setAllowUserInteraction(allowUserInteraction);
    }

    @Override
    public boolean getUseCaches() {
        return this.jarURLConnection.getUseCaches();
    }

    @Override
    public void setUseCaches(boolean useCaches) {
        this.jarURLConnection.setUseCaches(useCaches);
    }

    @Override
    public long getIfModifiedSince() {
        return this.jarURLConnection.getIfModifiedSince();
    }

    @Override
    public void setIfModifiedSince(long ifModifiedSince) {
        this.jarURLConnection.setIfModifiedSince(ifModifiedSince);
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.jarURLConnection.getDefaultUseCaches();
    }

    @Override
    public void setDefaultUseCaches(boolean defaultUseCaches) {
        this.jarURLConnection.setDefaultUseCaches(defaultUseCaches);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.jarURLConnection.setRequestProperty(key, value);
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.jarURLConnection.addRequestProperty(key, value);
    }

    @Override
    public String getRequestProperty(String key) {
        return this.jarURLConnection.getRequestProperty(key);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.jarURLConnection.getRequestProperties();
    }

    @Override
    public URL getJarFileURL() {
        return this.jarURLConnection.getJarFileURL();
    }

    @Override
    public String getEntryName() {
        return this.jarURLConnection.getEntryName();
    }

    @Override
    public JarFile getJarFile() throws IOException {
        return this.jarURLConnection.getJarFile();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarURLConnection.getManifest();
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        return this.jarURLConnection.getJarEntry();
    }

    @Override
    public Attributes getAttributes() throws IOException {
        return this.jarURLConnection.getAttributes();
    }

    @Override
    public Attributes getMainAttributes() throws IOException {
        return this.jarURLConnection.getMainAttributes();
    }

    @Override
    public Certificate[] getCertificates() throws IOException {
        return this.jarURLConnection.getCertificates();
    }
}

