/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.execute;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.shade.screw.Config;
import org.aoju.bus.shade.screw.engine.EngineFactory;
import org.aoju.bus.shade.screw.engine.TemplateEngine;
import org.aoju.bus.shade.screw.execute.AbstractExecute;
import org.aoju.bus.shade.screw.metadata.DataSchema;
import org.aoju.bus.shade.screw.process.DataModelProcess;

public class ProduceExecute
extends AbstractExecute {
    public ProduceExecute(Config config) {
        super(config);
    }

    @Override
    public void execute() {
        try {
            long start = System.currentTimeMillis();
            DataSchema dataModel = new DataModelProcess(this.config).process();
            TemplateEngine produce = new EngineFactory(this.config.getEngineConfig()).newInstance();
            produce.produce(dataModel, this.getDocName(dataModel.getDatabase()));
            Logger.debug((String)"database document generation complete time consuming:{}ms", (Object[])new Object[]{System.currentTimeMillis() - start});
        }
        catch (Exception e) {
            throw new InstrumentException((Throwable)e);
        }
    }
}

