/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;

public class JdkEncryptorProvider
implements EncryptorProvider {
    private final String algorithm;

    public JdkEncryptorProvider(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public void encrypt(Key key, File src, File dest) throws IOException {
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("could not make directory: " + dest.getParentFile());
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            this.encrypt(key, in, out);
        }
    }

    @Override
    public void encrypt(Key key, InputStream in, OutputStream out) throws IOException {
        CipherInputStream cis = null;
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, new SecretKeySpec(key.getEncryptKey(), this.algorithm));
            cis = new CipherInputStream(in, cipher);
            Builder.transfer((InputStream)cis, out);
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                Builder.close(cis);
                throw throwable;
            }
        }
        Builder.close(cis);
    }

    @Override
    public InputStream encrypt(Key key, InputStream in) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, new SecretKeySpec(key.getEncryptKey(), this.algorithm));
            return new CipherInputStream(in, cipher);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream encrypt(Key key, OutputStream out) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            cipher.init(1, new SecretKeySpec(key.getEncryptKey(), this.algorithm));
            return new CipherOutputStream(out, cipher);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

