/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot.jar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.boot.jar.JarURLHandler;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;

public class JarClassLoader
extends URLClassLoader {
    private final JarURLHandler jarURLHandler;

    public JarClassLoader(URL[] urls, ClassLoader parent, DecryptorProvider decryptorProvider, EncryptorProvider encryptorProvider, Key key) throws Exception {
        super(urls, parent);
        this.jarURLHandler = new JarURLHandler(decryptorProvider, encryptorProvider, key, this);
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (null == url) {
            return null;
        }
        try {
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), this.jarURLHandler);
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> enumeration = super.findResources(name);
        if (null == enumeration) {
            return null;
        }
        return new XJarEnumeration(enumeration);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassFormatError e) {
            Class<?> clazz;
            block11: {
                URL resource = this.findResource(name.replace('.', '/') + ".class");
                if (null == resource) {
                    throw new ClassNotFoundException(name, e);
                }
                InputStream in = resource.openStream();
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    Builder.transfer(in, bos);
                    byte[] bytes = bos.toByteArray();
                    clazz = this.defineClass(name, bytes, 0, bytes.length);
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        throw new ClassNotFoundException(name, t);
                    }
                }
                in.close();
            }
            return clazz;
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class XJarEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> enumeration;

        XJarEnumeration(Enumeration<URL> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public URL nextElement() {
            URL url = this.enumeration.nextElement();
            if (null == url) {
                return null;
            }
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), JarClassLoader.this.jarURLHandler);
            }
            catch (MalformedURLException e) {
                return url;
            }
        }
    }
}

