/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.engine;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.shade.screw.engine.EngineConfig;
import org.aoju.bus.shade.screw.engine.TemplateEngine;

public class EngineFactory
implements Serializable {
    private EngineConfig engineConfig;

    public EngineFactory(EngineConfig configuration) {
        Assert.notNull((Object)configuration, (String)"EngineConfig can not be empty!", (Object[])new Object[0]);
        this.engineConfig = configuration;
    }

    private EngineFactory() {
    }

    public TemplateEngine newInstance() {
        try {
            Class<? extends TemplateEngine> query = this.engineConfig.getProduceType().getImplClass();
            Constructor<? extends TemplateEngine> constructor = query.getConstructor(EngineConfig.class);
            return constructor.newInstance(this.engineConfig);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new InstrumentException((Throwable)e);
        }
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void setEngineConfig(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EngineFactory)) {
            return false;
        }
        EngineFactory other = (EngineFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EngineConfig this$engineConfig = this.getEngineConfig();
        EngineConfig other$engineConfig = other.getEngineConfig();
        return !(this$engineConfig == null ? other$engineConfig != null : !((Object)this$engineConfig).equals(other$engineConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EngineFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EngineConfig $engineConfig = this.getEngineConfig();
        result = result * 59 + ($engineConfig == null ? 43 : ((Object)$engineConfig).hashCode());
        return result;
    }

    public String toString() {
        return "EngineFactory(engineConfig=" + this.getEngineConfig() + ")";
    }
}

