/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect.mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.screw.dialect.AbstractDatabaseQuery;
import org.aoju.bus.shade.screw.dialect.mysql.MySqlColumn;
import org.aoju.bus.shade.screw.dialect.mysql.MySqlDatabase;
import org.aoju.bus.shade.screw.dialect.mysql.MySqlPrimaryKey;
import org.aoju.bus.shade.screw.dialect.mysql.MySqlTable;
import org.aoju.bus.shade.screw.mapping.Mapping;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;

public class MySqlDataBaseQuery
extends AbstractDatabaseQuery {
    public MySqlDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws InternalException {
        MySqlDatabase model = new MySqlDatabase();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<MySqlTable> getTables() throws InternalException {
        List<MySqlTable> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, MySqlTable.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MySqlDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        MySqlDataBaseQuery.close(resultSet);
        return list;
    }

    public List<MySqlColumn> getTableColumns(String table) throws InternalException {
        List<MySqlColumn> list;
        Assert.notEmpty((CharSequence)table, (String)"Table name can not be empty!", (Object[])new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<MySqlColumn> list2 = Mapping.convertList(resultSet, MySqlColumn.class);
            List<String> tableNames = list2.stream().map(MySqlColumn::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollKit.isEmpty((Map)this.columnsCaching)) {
                if (table.equals("%")) {
                    sql = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.COLUMN_TYPE, case when LOCATE('(', A.COLUMN_TYPE) > 0 then replace(substring(A.COLUMN_TYPE, LOCATE('(', A.COLUMN_TYPE) + 1), ')', '') else null end COLUMN_LENGTH FROM INFORMATION_SCHEMA.COLUMNS A WHERE A.TABLE_SCHEMA = '%s'";
                    PreparedStatement statement = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase()));
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.COLUMN_TYPE, case when LOCATE('(', A.COLUMN_TYPE) > 0 then replace(substring(A.COLUMN_TYPE, LOCATE('(', A.COLUMN_TYPE) + 1), ')', '') else null end COLUMN_LENGTH FROM INFORMATION_SCHEMA.COLUMNS A WHERE A.TABLE_SCHEMA = '%s' and A.TABLE_NAME = '%s'";
                    resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase(), table)).executeQuery();
                }
                List<MySqlColumn> inquires = Mapping.convertList(resultSet, MySqlColumn.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setColumnType(j.getColumnType());
                        i.setColumnLength(j.getColumnLength());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MySqlDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        MySqlDataBaseQuery.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws InternalException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws InternalException {
        List<MySqlPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, MySqlPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MySqlDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        MySqlDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InternalException {
        List<MySqlPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM, TABLE_NAME, COLUMN_NAME, SEQ_IN_INDEX AS KEY_SEQ, 'PRIMARY' AS PK_NAME FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = '%s' AND INDEX_NAME = 'PRIMARY' ORDER BY TABLE_SCHEMA, TABLE_NAME, INDEX_NAME, SEQ_IN_INDEX";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertList(resultSet, MySqlPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MySqlDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        MySqlDataBaseQuery.close(resultSet);
        return list;
    }
}

