/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.screw.dialect.AbstractDatabaseQuery;
import org.aoju.bus.shade.screw.dialect.oracle.OracleColumn;
import org.aoju.bus.shade.screw.dialect.oracle.OracleDatabase;
import org.aoju.bus.shade.screw.dialect.oracle.OraclePrimaryKey;
import org.aoju.bus.shade.screw.dialect.oracle.OracleTable;
import org.aoju.bus.shade.screw.mapping.Mapping;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;

public class OracleDataBaseQuery
extends AbstractDatabaseQuery {
    public OracleDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws InternalException {
        OracleDatabase model = new OracleDatabase();
        model.setDatabase(this.getSchema());
        return model;
    }

    public List<OracleTable> getTables() throws InternalException {
        List<OracleTable> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            List<OracleTable> list2 = Mapping.convertList(resultSet, OracleTable.class);
            Object sql = "SELECT TABLE_NAME,COMMENTS AS REMARKS FROM USER_TAB_COMMENTS WHERE TABLE_TYPE = 'TABLE'";
            if (this.isDda()) {
                sql = "SELECT TABLE_NAME,COMMENTS AS REMARKS FROM DBA_TAB_COMMENTS WHERE TABLE_TYPE = 'TABLE' AND OWNER = '" + this.getSchema() + "'";
            }
            resultSet = this.prepareStatement(String.format((String)sql, this.getSchema())).executeQuery();
            List<OracleTable> inquires = Mapping.convertList(resultSet, OracleTable.class);
            list2.forEach(model -> inquires.stream().filter(inquire -> model.getTableName().equals(inquire.getTableName())).forEachOrdered(inquire -> model.setRemarks(inquire.getRemarks())));
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                OracleDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        OracleDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    public List<OracleColumn> getTableColumns(String table) throws InternalException {
        List<OracleColumn> list;
        Assert.notEmpty((CharSequence)table, (String)"Table name can not be empty!", (Object[])new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<OracleColumn> list2 = Mapping.convertList(resultSet, OracleColumn.class);
            List<String> tableNames = list2.stream().map(OracleColumn::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollKit.isEmpty((Map)this.columnsCaching)) {
                if (table.equals("%")) {
                    sql = "SELECT ut.TABLE_NAME,  ut.COLUMN_NAME, uc.comments as REMARKS, concat(concat(concat(ut.DATA_TYPE, '('), ut.DATA_LENGTH), ')') AS COLUMN_TYPE, ut.DATA_LENGTH as COLUMN_LENGTH FROM user_tab_columns ut INNER JOIN user_col_comments uc ON ut.TABLE_NAME = uc.table_name AND ut.COLUMN_NAME = uc.column_name";
                    if (this.isDda()) {
                        sql = "SELECT ut.TABLE_NAME,  ut.COLUMN_NAME, uc.comments as REMARKS, concat(concat(concat(ut.DATA_TYPE, '('), ut.DATA_LENGTH), ')') AS COLUMN_TYPE, ut.DATA_LENGTH as COLUMN_LENGTH FROM dba_tab_columns ut INNER JOIN dba_col_comments uc ON ut.TABLE_NAME = uc.table_name AND ut.COLUMN_NAME = uc.column_name and ut.OWNER = uc.OWNER WHERE ut.OWNER = '" + this.getDataBase() + "'";
                    }
                    PreparedStatement statement = this.prepareStatement((String)sql);
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT ut.TABLE_NAME,  ut.COLUMN_NAME, uc.comments as REMARKS, concat(concat(concat(ut.DATA_TYPE, '('), ut.DATA_LENGTH), ')') AS COLUMN_TYPE, ut.DATA_LENGTH as COLUMN_LENGTH FROM user_tab_columns ut INNER JOIN user_col_comments uc ON ut.TABLE_NAME = uc.table_name AND ut.COLUMN_NAME = uc.column_name WHERE ut.Table_Name = '%s'";
                    if (this.isDda()) {
                        sql = "SELECT ut.TABLE_NAME,  ut.COLUMN_NAME, uc.comments as REMARKS, concat(concat(concat(ut.DATA_TYPE, '('), ut.DATA_LENGTH), ')') AS COLUMN_TYPE, ut.DATA_LENGTH as COLUMN_LENGTH FROM dba_tab_columns ut INNER JOIN dba_col_comments uc ON ut.TABLE_NAME = uc.table_name AND ut.COLUMN_NAME = uc.column_name and ut.OWNER = uc.OWNER WHERE ut.Table_Name = '%s' ut.OWNER = '" + this.getDataBase() + "'";
                    }
                    resultSet = this.prepareStatement(String.format((String)sql, table)).executeQuery();
                }
                List<OracleColumn> inquires = Mapping.convertList(resultSet, OracleColumn.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            for (OracleColumn i : list2) {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setRemarks(j.getRemarks());
                        i.setColumnLength(j.getColumnLength());
                        i.setColumnType(j.getColumnType());
                    }
                });
            }
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                OracleDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        OracleDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws InternalException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws InternalException {
        List<OraclePrimaryKey> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, OraclePrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                OracleDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        OracleDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InternalException {
        List<OraclePrimaryKey> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT NULL AS TABLE_CAT, C.OWNER AS TABLE_SCHEM, C.TABLE_NAME, C.COLUMN_NAME, C.POSITION AS KEY_SEQ, C.CONSTRAINT_NAME AS PK_NAME FROM ALL_CONS_COLUMNS C, ALL_CONSTRAINTS K WHERE K.CONSTRAINT_TYPE = 'P' AND K.OWNER LIKE '%s' ESCAPE '/' AND K.CONSTRAINT_NAME = C.CONSTRAINT_NAME AND K.TABLE_NAME = C.TABLE_NAME AND K.OWNER = C.OWNER ORDER BY COLUMN_NAME ";
            resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase())).executeQuery();
            list = Mapping.convertList(resultSet, OraclePrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                OracleDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        OracleDataBaseQuery.close(resultSet);
        return list;
    }

    private boolean isDda() {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = this.prepareStatement("SELECT USERENV('isdba') as IS_DBA FROM DUAL").executeQuery();
            String dbaColumn = "IS_DBA";
            resultSet.next();
            bl = resultSet.getBoolean(dbaColumn);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                OracleDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        OracleDataBaseQuery.close(resultSet);
        return bl;
    }
}

