/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.engine;

import java.io.File;
import java.io.IOException;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.shade.screw.engine.EngineConfig;
import org.aoju.bus.shade.screw.engine.TemplateEngine;

public abstract class AbstractEngine
implements TemplateEngine {
    private EngineConfig engineConfig;

    private AbstractEngine() {
    }

    public AbstractEngine(EngineConfig engineConfig) {
        Assert.notNull((Object)engineConfig, (String)"EngineConfig can not be empty!", (Object[])new Object[0]);
        this.engineConfig = engineConfig;
    }

    protected File getFile(String docName) {
        File file;
        if (StringKit.isBlank((CharSequence)this.getEngineConfig().getFileOutputDir())) {
            String dir = System.getProperty("user.dir");
            file = new File(dir + "/doc");
        } else {
            file = new File(this.getEngineConfig().getFileOutputDir());
        }
        if (!file.exists()) {
            boolean dir = file.mkdirs();
        }
        String suffix = this.getEngineConfig().getFileType().getFileSuffix();
        file = new File(file, docName + suffix);
        this.getEngineConfig().setFileOutputDir(file.getParent());
        return file;
    }

    protected void openOutputDir() {
        if (this.getEngineConfig().isOpenOutputDir() && StringKit.isNotBlank((CharSequence)this.getEngineConfig().getFileOutputDir())) {
            try {
                String osName = System.getProperty("os.name");
                if (null != osName) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + this.getEngineConfig().getFileOutputDir());
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + this.getEngineConfig().getFileOutputDir());
                    }
                }
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        }
    }

    public EngineConfig getEngineConfig() {
        return this.engineConfig;
    }

    public void setEngineConfig(EngineConfig engineConfig) {
        this.engineConfig = engineConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEngine)) {
            return false;
        }
        AbstractEngine other = (AbstractEngine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EngineConfig this$engineConfig = this.getEngineConfig();
        EngineConfig other$engineConfig = other.getEngineConfig();
        return !(this$engineConfig == null ? other$engineConfig != null : !((Object)this$engineConfig).equals(other$engineConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractEngine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EngineConfig $engineConfig = this.getEngineConfig();
        result = result * 59 + ($engineConfig == null ? 43 : ((Object)$engineConfig).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractEngine(engineConfig=" + this.getEngineConfig() + ")";
    }
}

