/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.beans;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.aoju.bus.shade.beans.PropertyInfo;
import org.aoju.bus.shade.beans.TableEntity;

public class Builder {
    public static final String ENTITY = "Entity";
    public static final String MAPPER = "Mapper";
    public static final String MAPPER_XML = "MapperXml";
    public static final String SERVICE = "Service";
    public static final String SERVICE_IMPL = "ServiceImpl";
    public static final String CONTROLLER = "Controller";
    public static final String SUFFIX = ".ftl";

    public static Object createEntity(String url, TableEntity tableEntity) {
        String fileUrl = Builder.getFileUrl(url, tableEntity.getEntityUrl(), tableEntity.getEntityName(), ENTITY);
        return Builder.createFile(tableEntity, "Entity.ftl", fileUrl);
    }

    public static Object createMapper(String url, TableEntity tableEntity) {
        String fileUrl = Builder.getFileUrl(url, tableEntity.getMapperUrl(), tableEntity.getEntityName(), MAPPER);
        return Builder.createFile(tableEntity, "Mapper.ftl", fileUrl);
    }

    public static Object createMapperXml(String url, TableEntity tableEntity) {
        String fileUrl = Builder.getFileUrl(url, tableEntity.getMapperXmlUrl(), tableEntity.getEntityName(), MAPPER_XML);
        List<PropertyInfo> list = tableEntity.getCis();
        Object agile = "";
        for (PropertyInfo propertyInfo : list) {
            agile = (String)agile + propertyInfo.getColumn() + ",\n\t\t";
        }
        agile = ((String)agile).substring(0, ((String)agile).length() - 4);
        tableEntity.setAgile((String)agile);
        return Builder.createFile(tableEntity, "MapperXml.ftl", fileUrl);
    }

    public static Object createService(String url, TableEntity tableEntity) {
        String fileUrl = Builder.getFileUrl(url, tableEntity.getServiceUrl(), tableEntity.getEntityName(), SERVICE);
        return Builder.createFile(tableEntity, "Service.ftl", fileUrl);
    }

    public static Object createServiceImpl(String url, TableEntity tableEntity) {
        String fileUrl = Builder.getFileUrl(url, tableEntity.getServiceImplUrl(), tableEntity.getEntityName(), SERVICE_IMPL);
        return Builder.createFile(tableEntity, "ServiceImpl.ftl", fileUrl);
    }

    public static Object createController(String url, TableEntity tableEntity) {
        String fileUrl = Builder.getFileUrl(url, tableEntity.getControllerUrl(), tableEntity.getEntityName(), CONTROLLER);
        return Builder.createFile(tableEntity, "Controller.ftl", fileUrl);
    }

    private static String getFileUrl(String url, String packageUrl, String entityName, String type) {
        if (ENTITY.equals(type)) {
            return url + packageUrl.replace(".", "/") + "/" + entityName + ".java";
        }
        if (MAPPER.equals(type)) {
            return url + packageUrl.replace(".", "/") + "/" + entityName + "Mapper.java";
        }
        if (MAPPER_XML.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "Mapper.xml";
        }
        if (SERVICE.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "Service.java";
        }
        if (SERVICE_IMPL.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "ServiceImpl.java";
        }
        if (CONTROLLER.equals(type)) {
            return url + Builder.pageToUrl(packageUrl) + entityName + "Controller.java";
        }
        return null;
    }

    private static String pageToUrl(String url) {
        return url.replace(".", "/") + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object createFile(TableEntity tableEntity, String templateName, String filePath) {
        OutputStreamWriter out = null;
        try {
            Configuration configuration = new Configuration(Configuration.VERSION_2_3_28);
            configuration.setClassForTemplateLoading(org.aoju.bus.shade.screw.Builder.class, "/META-INF/template");
            configuration.setDefaultEncoding("UTF-8");
            Template template = configuration.getTemplate(templateName);
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.exists()) {
                String string = "The file already exists:" + filePath;
                return string;
            }
            file.createNewFile();
            out = new FileWriter(file);
            template.process((Object)tableEntity, (Writer)out);
            String string = "create a file :" + filePath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "failed to create file :" + filePath;
    }
}

