/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.Attributes;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.aoju.bus.shade.safety.Complex;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.algorithm.SecureRandom;
import org.aoju.bus.shade.safety.algorithm.SymmetricSecureKey;
import org.aoju.bus.shade.safety.complex.AllComplex;
import org.aoju.bus.shade.safety.complex.AnyComplex;
import org.aoju.bus.shade.safety.complex.NotComplex;

public abstract class Builder {
    public static final String WEB_INF_CLASSES = "WEB-INF/classes/";
    public static final String WEB_INF_LIB = "WEB-INF/lib/";
    public static final String META_INF_MANIFEST = "META-INF/MANIFEST.MF";
    public static final String XJAR_SRC_DIR = Builder.class.getPackage().getName().replace('.', '/') + "/";
    public static final String XJAR_INF_DIR = "META-INF/";
    public static final String XJAR_INF_IDX = "FOREST.MF";
    public static final String XJAR_ALGORITHM = "--xjar.algorithm=";
    public static final String XJAR_KEYSIZE = "--xjar.keysize=";
    public static final String XJAR_IVSIZE = "--xjar.ivsize=";
    public static final String XJAR_PASSWORD = "--xjar.password=";
    public static final String XJAR_KEYFILE = "--xjar.keyfile=";
    public static final String XJAR_ALGORITHM_KEY = "Jar-Algorithm";
    public static final String XJAR_KEYSIZE_KEY = "Jar-Keysize";
    public static final String XJAR_IVSIZE_KEY = "Jar-Ivsize";
    public static final String XJAR_PASSWORD_KEY = "Jar-Password";
    public static final String XJAR_KEY_ALGORITHM = "algorithm";
    public static final String XJAR_KEY_KEYSIZE = "keysize";
    public static final String XJAR_KEY_IVSIZE = "ivsize";
    public static final String XJAR_KEY_PASSWORD = "password";
    public static final String XJAR_KEY_HOLD = "hold";
    public static final String BOOT_INF_CLASSES = "BOOT-INF/classes/";
    public static final String BOOT_INF_LIB = "BOOT-INF/lib/";
    public static final String CRLF = System.getProperty("line.separator");
    public static final String ALGORITHM = "AES";
    public static int DEFAULT_KEYSIZE = 128;
    public static int DEFAULT_IVSIZE = 128;
    public static int FLAG_DANGER;
    public static int MODE_DANGER;
    public static int MODE_NORMAL;

    public static byte[] readln(InputStream in) throws IOException {
        int b = in.read();
        if (b == -1) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (b != -1) {
            switch (b) {
                case 13: {
                    break;
                }
                case 10: {
                    return bos.toByteArray();
                }
                default: {
                    bos.write(b);
                }
            }
            b = in.read();
        }
        return bos.toByteArray();
    }

    public static void writeln(OutputStream out, byte[] line) throws IOException {
        if (null == line) {
            return;
        }
        out.write(line);
        out.write(13);
        out.write(10);
    }

    public static void close(Closeable closeable) {
        try {
            Builder.close(closeable, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void close(Closeable closeable, boolean quietly) throws IOException {
        block3: {
            if (null == closeable) {
                return;
            }
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (quietly) break block3;
                throw e;
            }
        }
    }

    public static long transfer(InputStream in, OutputStream out) throws IOException {
        int length;
        long total = 0L;
        byte[] buffer = new byte[4096];
        while ((length = in.read(buffer)) != -1) {
            out.write(buffer, 0, length);
            total += (long)length;
        }
        out.flush();
        return total;
    }

    public static long transfer(Reader reader, Writer writer) throws IOException {
        int length;
        long total = 0L;
        char[] buffer = new char[4096];
        while ((length = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, length);
            total += (long)length;
        }
        writer.flush();
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(InputStream in, File file) throws IOException {
        long l;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            l = Builder.transfer(in, out);
        }
        catch (Throwable throwable) {
            Builder.close(out);
            throw throwable;
        }
        Builder.close(out);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(Reader reader, File file) throws IOException {
        long l;
        FileOutputStream out = null;
        OutputStreamWriter writer = null;
        try {
            out = new FileOutputStream(file);
            writer = new OutputStreamWriter(out);
            l = Builder.transfer(reader, writer);
        }
        catch (Throwable throwable) {
            Builder.close(writer);
            Builder.close(out);
            throw throwable;
        }
        Builder.close(writer);
        Builder.close(out);
        return l;
    }

    public static boolean delete(File file) {
        return Builder.delete(file, false);
    }

    public static boolean delete(File file, boolean recursively) {
        if (file.isDirectory() && recursively) {
            boolean deleted = true;
            File[] files = file.listFiles();
            for (int i = 0; null != files && i < files.length; ++i) {
                deleted &= Builder.delete(files[i], true);
            }
            return deleted && file.delete();
        }
        return file.delete();
    }

    public static Key key(String password) throws NoSuchAlgorithmException {
        return Builder.key(ALGORITHM, DEFAULT_KEYSIZE, DEFAULT_IVSIZE, password);
    }

    public static Key key(String algorithm, String password) throws NoSuchAlgorithmException {
        return Builder.key(algorithm, DEFAULT_KEYSIZE, DEFAULT_IVSIZE, password);
    }

    public static Key key(String algorithm, int keysize, String password) throws NoSuchAlgorithmException {
        return Builder.key(algorithm, keysize, DEFAULT_IVSIZE, password);
    }

    public static Key key(String algorithm, int keysize, int ivsize, String password) throws NoSuchAlgorithmException {
        MessageDigest sha512 = MessageDigest.getInstance("SHA-512");
        byte[] seed = sha512.digest(password.getBytes());
        KeyGenerator generator = KeyGenerator.getInstance(algorithm.split("[/]")[0]);
        SecureRandom random = new SecureRandom(seed);
        generator.init(keysize, (java.security.SecureRandom)random);
        SecretKey key = generator.generateKey();
        generator.init(ivsize, (java.security.SecureRandom)random);
        SecretKey iv = generator.generateKey();
        return new SymmetricSecureKey(algorithm, keysize, ivsize, password, key.getEncoded(), iv.getEncoded());
    }

    public static void retainKey(Key key, Attributes attributes) {
        attributes.putValue(XJAR_ALGORITHM_KEY, key.getAlgorithm());
        attributes.putValue(XJAR_KEYSIZE_KEY, String.valueOf(key.getKeysize()));
        attributes.putValue(XJAR_IVSIZE_KEY, String.valueOf(key.getIvsize()));
        attributes.putValue(XJAR_PASSWORD_KEY, key.getPassword());
    }

    public static void removeKey(Attributes attributes) {
        attributes.remove(new Attributes.Name(XJAR_ALGORITHM_KEY));
        attributes.remove(new Attributes.Name(XJAR_KEYSIZE_KEY));
        attributes.remove(new Attributes.Name(XJAR_IVSIZE_KEY));
        attributes.remove(new Attributes.Name(XJAR_PASSWORD_KEY));
    }

    public static <E> AllComplex<E> all() {
        return new AllComplex();
    }

    public static <E> AllComplex<E> all(Collection<? extends Complex<E>> filters) {
        return new AllComplex(filters);
    }

    public static <E> AllComplex<E> and() {
        return new AllComplex();
    }

    public static <E> AllComplex<E> and(Collection<? extends Complex<E>> filters) {
        return new AllComplex(filters);
    }

    public static <E> AnyComplex<E> any() {
        return new AnyComplex();
    }

    public static <E> AnyComplex<E> any(Collection<? extends Complex<E>> filters) {
        return new AnyComplex(filters);
    }

    public static <E> AnyComplex<E> or() {
        return new AnyComplex();
    }

    public static <E> AnyComplex<E> or(Collection<? extends Complex<E>> filters) {
        return new AnyComplex(filters);
    }

    public static <E> Complex<E> not(Complex<E> filter) {
        return new NotComplex<E>(filter);
    }

    public static boolean isRelative(String path) {
        return !Builder.isAbsolute(path);
    }

    public static boolean isAbsolute(String path) {
        if (path.startsWith("/")) {
            return true;
        }
        HashSet roots = new HashSet();
        Collections.addAll(roots, File.listRoots());
        File root = new File(path);
        while (null != root.getParentFile()) {
            root = root.getParentFile();
        }
        return roots.contains(root);
    }

    public static String absolutize(String path) {
        return Builder.normalize((String)(Builder.isAbsolute(path) ? path : System.getProperty("user.dir") + File.separator + path));
    }

    public static String normalize(String path) {
        return path.replaceAll("[/\\\\]+", "/");
    }

    static {
        MODE_DANGER = FLAG_DANGER = 1;
        MODE_NORMAL = 0;
    }
}

