/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.beans;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.shade.beans.NamingRules;
import org.aoju.bus.shade.beans.PropertyInfo;

public class TableEntity
implements Serializable {
    private String project;
    private String author;
    private String version;
    private String url;
    private String user;
    private String password;
    private String database;
    private String table;
    private String entityName;
    private String objectName;
    private String entityComment;
    private String createTime;
    private String agile;
    private String entityUrl;
    private String mapperUrl;
    private String mapperXmlUrl;
    private String serviceUrl;
    private String serviceImplUrl;
    private String controllerUrl;
    private String idType;
    private String idJdbcType;
    private List<PropertyInfo> cis;
    private String isSwagger;
    private boolean isHump;
    private String isDubbo;

    public TableEntity(String project, String author, String version, String url, String user, String password, String database, String table, String agile, String entityUrl, String mapperUrl, String mapperXmlUrl, String serviceUrl, String serviceImplUrl, String controllerUrl, String isSwagger, String isDubbo, boolean isHump) {
        this.project = project;
        this.author = author;
        this.version = version;
        this.url = url.replace("database", database);
        this.user = user;
        this.password = password;
        this.database = database;
        this.table = table;
        this.agile = agile;
        this.entityUrl = entityUrl;
        this.mapperUrl = mapperUrl;
        this.mapperXmlUrl = mapperXmlUrl;
        this.serviceUrl = serviceUrl;
        this.serviceImplUrl = serviceImplUrl;
        this.controllerUrl = controllerUrl;
        this.isSwagger = isSwagger;
        this.isDubbo = isDubbo;
        this.isHump = isHump;
    }

    public static TableEntity get(TableEntity entity) {
        ArrayList<PropertyInfo> columns = new ArrayList<PropertyInfo>();
        Connection con = null;
        Statement pstemt = null;
        ResultSet rs = null;
        String sql = "select column_name,data_type,column_comment from information_schema.columns where table_schema='" + entity.getDatabase() + "' and table_name='" + entity.getTable() + "'";
        try {
            Object column;
            con = DriverManager.getConnection(entity.url, entity.user, entity.password);
            pstemt = con.prepareStatement(sql);
            rs = pstemt.executeQuery();
            while (rs.next()) {
                column = rs.getString(1);
                String jdbcType = rs.getString(2);
                String comment = rs.getString(3);
                PropertyInfo ci = new PropertyInfo();
                ci.setColumn((String)column);
                if (jdbcType.equalsIgnoreCase("int")) {
                    ci.setJdbcType("Integer");
                } else if (jdbcType.equalsIgnoreCase("datetime")) {
                    ci.setJdbcType("timestamp");
                } else {
                    ci.setJdbcType(jdbcType);
                }
                ci.setComment(comment);
                ci.setProperty(NamingRules.changeToJavaFiled((String)column, entity.isHump));
                ci.setJavaType(NamingRules.jdbcTypeToJavaType(jdbcType));
                if (((String)column).equalsIgnoreCase("id")) {
                    entity.setIdType(ci.getJavaType());
                    entity.setIdJdbcType(ci.getJdbcType());
                }
                columns.add(ci);
            }
            entity.setCis(columns);
            rs.close();
            pstemt.close();
            con.close();
            if (null == columns || columns.size() == 0) {
                throw new RuntimeException("\u672a\u80fd\u8bfb\u53d6\u5230\u8868\u6216\u8868\u4e2d\u7684\u5b57\u6bb5 \u8bf7\u68c0\u67e5\u94fe\u63a5url,\u6570\u636e\u5e93\u8d26\u6237,\u6570\u636e\u5e93\u5bc6\u7801,\u67e5\u8be2\u7684\u6570\u636e\u540d\u3001\u662f\u5426\u6b63\u786e ");
            }
            column = entity;
            return column;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u81ea\u52a8\u751f\u6210\u5b9e\u4f53\u7c7b\u9519\u8bef\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (null != pstemt) {
                    pstemt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (null != con) {
                    con.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public String getProject() {
        return this.project;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getEntityComment() {
        return this.entityComment;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getAgile() {
        return this.agile;
    }

    public String getEntityUrl() {
        return this.entityUrl;
    }

    public String getMapperUrl() {
        return this.mapperUrl;
    }

    public String getMapperXmlUrl() {
        return this.mapperXmlUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getServiceImplUrl() {
        return this.serviceImplUrl;
    }

    public String getControllerUrl() {
        return this.controllerUrl;
    }

    public String getIdType() {
        return this.idType;
    }

    public String getIdJdbcType() {
        return this.idJdbcType;
    }

    public List<PropertyInfo> getCis() {
        return this.cis;
    }

    public String getIsSwagger() {
        return this.isSwagger;
    }

    public boolean isHump() {
        return this.isHump;
    }

    public String getIsDubbo() {
        return this.isDubbo;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setEntityComment(String entityComment) {
        this.entityComment = entityComment;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setAgile(String agile) {
        this.agile = agile;
    }

    public void setEntityUrl(String entityUrl) {
        this.entityUrl = entityUrl;
    }

    public void setMapperUrl(String mapperUrl) {
        this.mapperUrl = mapperUrl;
    }

    public void setMapperXmlUrl(String mapperXmlUrl) {
        this.mapperXmlUrl = mapperXmlUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceImplUrl(String serviceImplUrl) {
        this.serviceImplUrl = serviceImplUrl;
    }

    public void setControllerUrl(String controllerUrl) {
        this.controllerUrl = controllerUrl;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public void setIdJdbcType(String idJdbcType) {
        this.idJdbcType = idJdbcType;
    }

    public void setCis(List<PropertyInfo> cis) {
        this.cis = cis;
    }

    public void setIsSwagger(String isSwagger) {
        this.isSwagger = isSwagger;
    }

    public void setHump(boolean isHump) {
        this.isHump = isHump;
    }

    public void setIsDubbo(String isDubbo) {
        this.isDubbo = isDubbo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableEntity)) {
            return false;
        }
        TableEntity other = (TableEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHump() != other.isHump()) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$entityName = this.getEntityName();
        String other$entityName = other.getEntityName();
        if (this$entityName == null ? other$entityName != null : !this$entityName.equals(other$entityName)) {
            return false;
        }
        String this$objectName = this.getObjectName();
        String other$objectName = other.getObjectName();
        if (this$objectName == null ? other$objectName != null : !this$objectName.equals(other$objectName)) {
            return false;
        }
        String this$entityComment = this.getEntityComment();
        String other$entityComment = other.getEntityComment();
        if (this$entityComment == null ? other$entityComment != null : !this$entityComment.equals(other$entityComment)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$agile = this.getAgile();
        String other$agile = other.getAgile();
        if (this$agile == null ? other$agile != null : !this$agile.equals(other$agile)) {
            return false;
        }
        String this$entityUrl = this.getEntityUrl();
        String other$entityUrl = other.getEntityUrl();
        if (this$entityUrl == null ? other$entityUrl != null : !this$entityUrl.equals(other$entityUrl)) {
            return false;
        }
        String this$mapperUrl = this.getMapperUrl();
        String other$mapperUrl = other.getMapperUrl();
        if (this$mapperUrl == null ? other$mapperUrl != null : !this$mapperUrl.equals(other$mapperUrl)) {
            return false;
        }
        String this$mapperXmlUrl = this.getMapperXmlUrl();
        String other$mapperXmlUrl = other.getMapperXmlUrl();
        if (this$mapperXmlUrl == null ? other$mapperXmlUrl != null : !this$mapperXmlUrl.equals(other$mapperXmlUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$serviceImplUrl = this.getServiceImplUrl();
        String other$serviceImplUrl = other.getServiceImplUrl();
        if (this$serviceImplUrl == null ? other$serviceImplUrl != null : !this$serviceImplUrl.equals(other$serviceImplUrl)) {
            return false;
        }
        String this$controllerUrl = this.getControllerUrl();
        String other$controllerUrl = other.getControllerUrl();
        if (this$controllerUrl == null ? other$controllerUrl != null : !this$controllerUrl.equals(other$controllerUrl)) {
            return false;
        }
        String this$idType = this.getIdType();
        String other$idType = other.getIdType();
        if (this$idType == null ? other$idType != null : !this$idType.equals(other$idType)) {
            return false;
        }
        String this$idJdbcType = this.getIdJdbcType();
        String other$idJdbcType = other.getIdJdbcType();
        if (this$idJdbcType == null ? other$idJdbcType != null : !this$idJdbcType.equals(other$idJdbcType)) {
            return false;
        }
        List<PropertyInfo> this$cis = this.getCis();
        List<PropertyInfo> other$cis = other.getCis();
        if (this$cis == null ? other$cis != null : !((Object)this$cis).equals(other$cis)) {
            return false;
        }
        String this$isSwagger = this.getIsSwagger();
        String other$isSwagger = other.getIsSwagger();
        if (this$isSwagger == null ? other$isSwagger != null : !this$isSwagger.equals(other$isSwagger)) {
            return false;
        }
        String this$isDubbo = this.getIsDubbo();
        String other$isDubbo = other.getIsDubbo();
        return !(this$isDubbo == null ? other$isDubbo != null : !this$isDubbo.equals(other$isDubbo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHump() ? 79 : 97);
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $entityName = this.getEntityName();
        result = result * 59 + ($entityName == null ? 43 : $entityName.hashCode());
        String $objectName = this.getObjectName();
        result = result * 59 + ($objectName == null ? 43 : $objectName.hashCode());
        String $entityComment = this.getEntityComment();
        result = result * 59 + ($entityComment == null ? 43 : $entityComment.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $agile = this.getAgile();
        result = result * 59 + ($agile == null ? 43 : $agile.hashCode());
        String $entityUrl = this.getEntityUrl();
        result = result * 59 + ($entityUrl == null ? 43 : $entityUrl.hashCode());
        String $mapperUrl = this.getMapperUrl();
        result = result * 59 + ($mapperUrl == null ? 43 : $mapperUrl.hashCode());
        String $mapperXmlUrl = this.getMapperXmlUrl();
        result = result * 59 + ($mapperXmlUrl == null ? 43 : $mapperXmlUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $serviceImplUrl = this.getServiceImplUrl();
        result = result * 59 + ($serviceImplUrl == null ? 43 : $serviceImplUrl.hashCode());
        String $controllerUrl = this.getControllerUrl();
        result = result * 59 + ($controllerUrl == null ? 43 : $controllerUrl.hashCode());
        String $idType = this.getIdType();
        result = result * 59 + ($idType == null ? 43 : $idType.hashCode());
        String $idJdbcType = this.getIdJdbcType();
        result = result * 59 + ($idJdbcType == null ? 43 : $idJdbcType.hashCode());
        List<PropertyInfo> $cis = this.getCis();
        result = result * 59 + ($cis == null ? 43 : ((Object)$cis).hashCode());
        String $isSwagger = this.getIsSwagger();
        result = result * 59 + ($isSwagger == null ? 43 : $isSwagger.hashCode());
        String $isDubbo = this.getIsDubbo();
        result = result * 59 + ($isDubbo == null ? 43 : $isDubbo.hashCode());
        return result;
    }

    public String toString() {
        return "TableEntity(project=" + this.getProject() + ", author=" + this.getAuthor() + ", version=" + this.getVersion() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", entityName=" + this.getEntityName() + ", objectName=" + this.getObjectName() + ", entityComment=" + this.getEntityComment() + ", createTime=" + this.getCreateTime() + ", agile=" + this.getAgile() + ", entityUrl=" + this.getEntityUrl() + ", mapperUrl=" + this.getMapperUrl() + ", mapperXmlUrl=" + this.getMapperXmlUrl() + ", serviceUrl=" + this.getServiceUrl() + ", serviceImplUrl=" + this.getServiceImplUrl() + ", controllerUrl=" + this.getControllerUrl() + ", idType=" + this.getIdType() + ", idJdbcType=" + this.getIdJdbcType() + ", cis=" + String.valueOf(this.getCis()) + ", isSwagger=" + this.getIsSwagger() + ", isHump=" + this.isHump() + ", isDubbo=" + this.getIsDubbo() + ")";
    }
}

