/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.Complex;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.boot.jar.JarDecryptorProvider;
import org.aoju.bus.shade.safety.boot.jar.JarEncryptorProvider;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EncryptorProvider;
import org.aoju.bus.shade.safety.provider.JdkDecryptorProvider;
import org.aoju.bus.shade.safety.provider.JdkEncryptorProvider;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class Jar {
    public static void encrypt(String src, String dest, Key key) throws Exception {
        Jar.encrypt(new File(src), new File(dest), key);
    }

    public static void encrypt(String src, String dest, Key key, int mode) throws Exception {
        Jar.encrypt(new File(src), new File(dest), key, mode);
    }

    public static void encrypt(File src, File dest, Key key) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.encrypt((InputStream)in, (OutputStream)out, key);
        }
    }

    public static void encrypt(File src, File dest, Key key, int mode) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.encrypt((InputStream)in, (OutputStream)out, key, mode);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, Key key) throws Exception {
        JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider(new JdkEncryptorProvider(key.getAlgorithm()));
        xJarEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(InputStream in, OutputStream out, Key key, int mode) throws Exception {
        JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider((EncryptorProvider)new JdkEncryptorProvider(key.getAlgorithm()), 8, mode);
        xJarEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(String src, String dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(new File(src), new File(dest), key, filter);
    }

    public static void encrypt(String src, String dest, Key key, int mode, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(new File(src), new File(dest), key, mode, filter);
    }

    public static void encrypt(File src, File dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.encrypt((InputStream)in, (OutputStream)out, key, filter);
        }
    }

    public static void encrypt(File src, File dest, Key key, int mode, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.encrypt((InputStream)in, (OutputStream)out, key, mode, filter);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider((EncryptorProvider)new JdkEncryptorProvider(key.getAlgorithm()), filter);
        xJarEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(InputStream in, OutputStream out, Key key, int mode, Complex<JarArchiveEntry> filter) throws Exception {
        JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider(new JdkEncryptorProvider(key.getAlgorithm()), 8, mode, filter);
        xJarEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(String src, String dest, String password) throws Exception {
        Jar.encrypt(src, dest, password, "AES");
    }

    public static void encrypt(String src, String dest, String password, String algorithm) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        Jar.encrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize);
    }

    public static void encrypt(File src, File dest, String password) throws Exception {
        Jar.encrypt(src, dest, password, "AES");
    }

    public static void encrypt(File src, File dest, String password, String algorithm) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.encrypt((InputStream)in, (OutputStream)out, password, algorithm, keysize, ivsize);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, String password) throws Exception {
        Jar.encrypt(in, out, password, "AES");
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm) throws Exception {
        Jar.encrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize) throws Exception {
        Jar.encrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize) throws Exception {
        JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider(new JdkEncryptorProvider(algorithm));
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xJarEncryptor.encrypt(key, in, out);
    }

    public static void encrypt(String src, String dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(src, dest, password, "AES", filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void encrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize, filter);
    }

    public static void encrypt(File src, File dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(src, dest, password, "AES", filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void encrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.encrypt(in, out, password, algorithm, keysize, ivsize, filter);
        }
    }

    public static void encrypt(InputStream in, OutputStream out, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(in, out, password, "AES", filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.encrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void encrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        JarEncryptorProvider xJarEncryptor = new JarEncryptorProvider((EncryptorProvider)new JdkEncryptorProvider(algorithm), filter);
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xJarEncryptor.encrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, Key key) throws Exception {
        Jar.decrypt(new File(src), new File(dest), key);
    }

    public static void decrypt(File src, File dest, Key key) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.decrypt((InputStream)in, (OutputStream)out, key);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, Key key) throws Exception {
        JarDecryptorProvider xJarDecryptor = new JarDecryptorProvider(new JdkDecryptorProvider(key.getAlgorithm()));
        xJarDecryptor.decrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(new File(src), new File(dest), key, filter);
    }

    public static void decrypt(File src, File dest, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.decrypt((InputStream)in, (OutputStream)out, key, filter);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, Key key, Complex<JarArchiveEntry> filter) throws Exception {
        JarDecryptorProvider xJarDecryptor = new JarDecryptorProvider((DecryptorProvider)new JdkDecryptorProvider(key.getAlgorithm()), filter);
        xJarDecryptor.decrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, String password) throws Exception {
        Jar.decrypt(src, dest, password, "AES");
    }

    public static void decrypt(String src, String dest, String password, String algorithm) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        Jar.decrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize);
    }

    public static void decrypt(File src, File dest, String password) throws Exception {
        Jar.decrypt(src, dest, password, "AES");
    }

    public static void decrypt(File src, File dest, String password, String algorithm) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.decrypt((InputStream)in, (OutputStream)out, password, algorithm, keysize, ivsize);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String password) throws Exception {
        Jar.decrypt(in, out, password, "AES");
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm) throws Exception {
        Jar.decrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize) throws Exception {
        Jar.decrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize) throws Exception {
        JarDecryptorProvider xJarDecryptor = new JarDecryptorProvider(new JdkDecryptorProvider(algorithm));
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xJarDecryptor.decrypt(key, in, out);
    }

    public static void decrypt(String src, String dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(src, dest, password, "AES", filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void decrypt(String src, String dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(new File(src), new File(dest), password, algorithm, keysize, ivsize, filter);
    }

    public static void decrypt(File src, File dest, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(src, dest, password, "AES", filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(src, dest, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void decrypt(File src, File dest, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            Jar.decrypt(in, out, password, algorithm, keysize, ivsize, filter);
        }
    }

    public static void decrypt(InputStream in, OutputStream out, String password, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(in, out, password, "AES", filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(in, out, password, algorithm, Builder.DEFAULT_KEYSIZE, filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, Complex<JarArchiveEntry> filter) throws Exception {
        Jar.decrypt(in, out, password, algorithm, keysize, Builder.DEFAULT_IVSIZE, filter);
    }

    public static void decrypt(InputStream in, OutputStream out, String password, String algorithm, int keysize, int ivsize, Complex<JarArchiveEntry> filter) throws Exception {
        JarDecryptorProvider xJarDecryptor = new JarDecryptorProvider((DecryptorProvider)new JdkDecryptorProvider(algorithm), filter);
        Key key = Builder.key(algorithm, keysize, ivsize, password);
        xJarDecryptor.decrypt(key, in, out);
    }
}

