/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.safety.boot.jar;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.aoju.bus.shade.safety.Builder;
import org.aoju.bus.shade.safety.Complex;
import org.aoju.bus.shade.safety.algorithm.Key;
import org.aoju.bus.shade.safety.boot.jar.JarAllComplex;
import org.aoju.bus.shade.safety.provider.DecryptorProvider;
import org.aoju.bus.shade.safety.provider.EntryDecryptorProvider;
import org.aoju.bus.shade.safety.streams.AlwaysInputStream;
import org.aoju.bus.shade.safety.streams.AlwaysOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;

public class JarDecryptorProvider
extends EntryDecryptorProvider<JarArchiveEntry>
implements DecryptorProvider {
    private final int level;

    public JarDecryptorProvider(DecryptorProvider xEncryptor) {
        this(xEncryptor, new JarAllComplex());
    }

    public JarDecryptorProvider(DecryptorProvider decryptorProvider, Complex<JarArchiveEntry> filter) {
        this(decryptorProvider, 8, filter);
    }

    public JarDecryptorProvider(DecryptorProvider xEncryptor, int level) {
        this(xEncryptor, level, new JarAllComplex());
    }

    public JarDecryptorProvider(DecryptorProvider decryptorProvider, int level, Complex<JarArchiveEntry> filter) {
        super(decryptorProvider, filter);
        this.level = level;
    }

    @Override
    public void decrypt(Key key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.decrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(Key key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        try {
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            AlwaysInputStream nis = new AlwaysInputStream((InputStream)zis);
            AlwaysOutputStream nos = new AlwaysOutputStream((OutputStream)zos);
            while (null != (entry = zis.getNextJarEntry())) {
                if (entry.getName().startsWith(Builder.XJAR_SRC_DIR) || entry.getName().endsWith("META-INF/") || entry.getName().endsWith("META-INF/FOREST.MF")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    Manifest manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass = attributes.getValue("Jar-Main-Class");
                    if (null != mainClass) {
                        attributes.putValue("Main-Class", mainClass);
                        attributes.remove(new Attributes.Name("Jar-Main-Class"));
                    }
                    Builder.removeKey(attributes);
                    JarArchiveEntry jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    manifest.write(nos);
                } else {
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    boolean filtered = this.on(entry);
                    DecryptorProvider decryptor = filtered ? this.decryptorProvider : this.xNopDecryptor;
                    try (OutputStream eos = decryptor.decrypt(key, nos);){
                        Builder.transfer((InputStream)nis, eos);
                    }
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            Builder.close(zis);
            Builder.close(zos);
            throw throwable;
        }
        Builder.close((Closeable)zis);
        Builder.close((Closeable)zos);
    }
}

