/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.dialect.mariadb;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.shade.screw.dialect.AbstractDatabaseQuery;
import org.aoju.bus.shade.screw.dialect.mariadb.MariadbColumn;
import org.aoju.bus.shade.screw.dialect.mariadb.MariadbDatabase;
import org.aoju.bus.shade.screw.dialect.mariadb.MariadbPrimaryKey;
import org.aoju.bus.shade.screw.dialect.mariadb.MariadbTable;
import org.aoju.bus.shade.screw.mapping.Mapping;
import org.aoju.bus.shade.screw.metadata.Column;
import org.aoju.bus.shade.screw.metadata.Database;
import org.aoju.bus.shade.screw.metadata.PrimaryKey;

public class MariaDbDataBaseQuery
extends AbstractDatabaseQuery {
    public MariaDbDataBaseQuery(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public Database getDataBase() throws InternalException {
        MariadbDatabase model = new MariadbDatabase();
        model.setDatabase(this.getCatalog());
        return model;
    }

    public List<MariadbTable> getTables() throws InternalException {
        List<MariadbTable> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getTables(this.getCatalog(), this.getSchema(), "%", new String[]{"TABLE"});
            list = Mapping.convertList(resultSet, MariadbTable.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MariaDbDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        MariaDbDataBaseQuery.close(resultSet);
        return list;
    }

    public List<MariadbColumn> getTableColumns(String table) throws InternalException {
        List<MariadbColumn> list;
        Assert.notEmpty((CharSequence)table, (String)"Table name can not be empty!", (Object[])new Object[0]);
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), table, "%");
            List<MariadbColumn> list2 = Mapping.convertList(resultSet, MariadbColumn.class);
            List<String> tableNames = list2.stream().map(MariadbColumn::getTableName).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
            if (CollKit.isEmpty((Map)this.columnsCaching)) {
                if (table.equals("%")) {
                    sql = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.COLUMN_TYPE, case when LOCATE('(', A.COLUMN_TYPE) > 0 then replace(substring(A.COLUMN_TYPE, LOCATE('(', A.COLUMN_TYPE) + 1), ')', '') else null end COLUMN_LENGTH FROM INFORMATION_SCHEMA.COLUMNS A WHERE A.TABLE_SCHEMA = '%s'";
                    PreparedStatement statement = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase()));
                    resultSet = statement.executeQuery();
                    int fetchSize = 4284;
                    if (resultSet.getFetchSize() < fetchSize) {
                        resultSet.setFetchSize(fetchSize);
                    }
                } else {
                    sql = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.COLUMN_TYPE, case when LOCATE('(', A.COLUMN_TYPE) > 0 then replace(substring(A.COLUMN_TYPE, LOCATE('(', A.COLUMN_TYPE) + 1), ')', '') else null end COLUMN_LENGTH FROM INFORMATION_SCHEMA.COLUMNS A WHERE A.TABLE_SCHEMA = '%s' and A.TABLE_NAME = '%s'";
                    resultSet = this.prepareStatement(String.format(sql, this.getDataBase().getDatabase(), table)).executeQuery();
                }
                List<MariadbColumn> inquires = Mapping.convertList(resultSet, MariadbColumn.class);
                tableNames.forEach(name -> this.columnsCaching.put(name, inquires.stream().filter(i -> i.getTableName().equals(name)).collect(Collectors.toList())));
            }
            list2.forEach(i -> {
                List columns = (List)this.columnsCaching.get(i.getTableName());
                columns.forEach(j -> {
                    if (i.getColumnName().equals(j.getColumnName()) && i.getTableName().equals(j.getTableName())) {
                        i.setColumnType(j.getColumnType());
                        i.setColumnLength(j.getColumnLength());
                    }
                });
            });
            list = list2;
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MariaDbDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        MariaDbDataBaseQuery.close(resultSet);
        return list;
    }

    @Override
    public List<? extends Column> getTableColumns() throws InternalException {
        return this.getTableColumns("%");
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys(String table) throws InternalException {
        List<MariadbPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            resultSet = this.getMetaData().getPrimaryKeys(this.getCatalog(), this.getSchema(), table);
            list = Mapping.convertList(resultSet, MariadbPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MariaDbDataBaseQuery.close(resultSet, this.connection);
                throw throwable;
            }
        }
        MariaDbDataBaseQuery.close(resultSet, this.connection);
        return list;
    }

    @Override
    public List<? extends PrimaryKey> getPrimaryKeys() throws InternalException {
        List<MariadbPrimaryKey> list;
        ResultSet resultSet = null;
        try {
            String sql = "SELECT A.TABLE_SCHEMA TABLE_CAT, NULL TABLE_SCHEM, A.TABLE_NAME, A.COLUMN_NAME, B.SEQ_IN_INDEX KEY_SEQ, B.INDEX_NAME PK_NAME FROM INFORMATION_SCHEMA.COLUMNS A, INFORMATION_SCHEMA.STATISTICS B WHERE A.COLUMN_KEY in('PRI', 'pri') AND B.INDEX_NAME = 'PRIMARY' AND (A.TABLE_SCHEMA = '%s') AND (B.TABLE_SCHEMA = '%s') AND A.TABLE_SCHEMA = B.TABLE_SCHEMA AND A.TABLE_NAME = B.TABLE_NAME AND A.COLUMN_NAME = B.COLUMN_NAME ORDER BY A.COLUMN_NAME";
            String database = this.getDataBase().getDatabase();
            resultSet = this.prepareStatement(String.format(sql, database, database)).executeQuery();
            list = Mapping.convertList(resultSet, MariadbPrimaryKey.class);
        }
        catch (SQLException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                MariaDbDataBaseQuery.close(resultSet);
                throw throwable;
            }
        }
        MariaDbDataBaseQuery.close(resultSet);
        return list;
    }
}

