/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.shade.screw.engine;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Objects;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.shade.screw.engine.AbstractEngine;
import org.aoju.bus.shade.screw.engine.EngineConfig;
import org.aoju.bus.shade.screw.engine.TemplateType;
import org.aoju.bus.shade.screw.metadata.DataSchema;

public class FreemarkerEngine
extends AbstractEngine {
    private final Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);

    public FreemarkerEngine(EngineConfig templateConfig) {
        super(templateConfig);
        try {
            String path = this.getEngineConfig().getCustomTemplate();
            if (StringKit.isNotBlank((CharSequence)path) && FileKit.exists((String)path)) {
                String parent = Objects.requireNonNull(FileKit.file((String)path)).getParent();
                this.configuration.setDirectoryForTemplateLoading(new File(parent));
            } else {
                this.configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), TemplateType.FREEMARKER.getTemplateDir()));
            }
            this.configuration.setDefaultEncoding("UTF-8");
            this.configuration.setLocale(new Locale("zh_CN"));
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void produce(DataSchema info, String docName) throws InternalException {
        Assert.notNull((Object)info, (String)"DataModel can not be empty!", (Object[])new Object[0]);
        String path = this.getEngineConfig().getCustomTemplate();
        try {
            Template template;
            if (StringKit.isNotBlank((CharSequence)path) && FileKit.exists((String)path)) {
                String fileName = new File(path).getName();
                template = this.configuration.getTemplate(fileName);
            } else {
                template = this.configuration.getTemplate(this.getEngineConfig().getFileType().getTemplateNamePrefix() + TemplateType.FREEMARKER.getSuffix());
            }
            File file = this.getFile(docName);
            try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.UTF_8));){
                template.process((Object)info, (Writer)out);
                this.openOutputDir();
            }
        }
        catch (TemplateException | IOException e) {
            throw new InternalException(e);
        }
    }
}

