/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.segment.BufferPool;
import org.aoju.bus.core.io.segment.EventFactory;
import org.aoju.bus.core.io.segment.RingBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.Function;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.NetMonitor;
import org.aoju.bus.socket.origin.Protocol;
import org.aoju.bus.socket.origin.ServerConfig;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.TcpAioSession;
import org.aoju.bus.socket.origin.TcpReadEvent;
import org.aoju.bus.socket.origin.TcpReadHandler;
import org.aoju.bus.socket.origin.TcpWriteHandler;

public class AioQuickServer<T> {
    protected ServerConfig<T> config = new ServerConfig();
    protected BufferPool bufferPool;
    protected TcpReadHandler<T> aioReadCompletionHandler;
    protected TcpWriteHandler<T> aioWriteCompletionHandler;
    private Function<AsynchronousSocketChannel, TcpAioSession<T>> aioSessionFunction;
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private Thread acceptThread = null;
    private volatile boolean running = true;

    public AioQuickServer(int port, Protocol<T> protocol, Message<T> messageProcessor) {
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
        this.config.setThreadNum(Runtime.getRuntime().availableProcessors());
    }

    public AioQuickServer(String host, int port, Protocol<T> protocol, Message<T> messageProcessor) {
        this(port, protocol, messageProcessor);
        this.config.setHost(host);
    }

    public void start() throws IOException {
        this.start0(new Function<AsynchronousSocketChannel, TcpAioSession<T>>(){

            @Override
            public TcpAioSession<T> apply(AsynchronousSocketChannel channel) {
                return new TcpAioSession(channel, AioQuickServer.this.config, AioQuickServer.this.aioReadCompletionHandler, AioQuickServer.this.aioWriteCompletionHandler, AioQuickServer.this.bufferPool.allocateBufferPage());
            }
        });
    }

    protected final void start0(Function<AsynchronousSocketChannel, TcpAioSession<T>> aioSessionFunction) throws IOException {
        if (this.config.getThreadNum() == 1) {
            this.config.setThreadNum(2);
        }
        int threadNum = this.config.getThreadNum();
        try {
            ThreadLocal<CompletionHandler> recursionThreadLocal = new ThreadLocal<CompletionHandler>();
            RingBuffer buffer = new RingBuffer(this.config.getReadBacklog(), (EventFactory)new EventFactory<TcpReadEvent>(){

                public TcpReadEvent newInstance() {
                    return new TcpReadEvent();
                }

                public void restEntity(TcpReadEvent entity) {
                    entity.setReadSize(-1);
                    entity.setSession(null);
                }
            });
            this.aioReadCompletionHandler = new TcpReadHandler((RingBuffer<TcpReadEvent>)buffer, recursionThreadLocal, new Semaphore(threadNum - 1));
            this.aioWriteCompletionHandler = new TcpWriteHandler();
            this.bufferPool = new BufferPool(ServerConfig.getIntProperty("bus-socket.server.pageSize", 0x100000), ServerConfig.getIntProperty("bus-socket.bufferPool.pageNum", threadNum), ServerConfig.getBoolProperty("bus-socket.server.page.isDirect", true));
            this.aioSessionFunction = aioSessionFunction;
            this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(threadNum, new ThreadFactory(){
                byte index = 0;

                @Override
                public Thread newThread(Runnable r) {
                    this.index = (byte)(this.index + 1);
                    return new Thread(r, "bus-socket:Thread-" + this.index);
                }
            });
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(this.asynchronousChannelGroup);
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 1000);
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), 1000);
            }
            this.acceptThread = new Thread(new Runnable(){
                NetMonitor<T> monitor;
                {
                    this.monitor = AioQuickServer.this.config.getMonitor();
                }

                @Override
                public void run() {
                    Future<AsynchronousSocketChannel> nextFuture = AioQuickServer.this.serverSocketChannel.accept();
                    while (AioQuickServer.this.running) {
                        try {
                            AsynchronousSocketChannel channel = nextFuture.get();
                            nextFuture = AioQuickServer.this.serverSocketChannel.accept();
                            if (this.monitor == null || this.monitor.acceptMonitor(channel)) {
                                AioQuickServer.this.createSession(channel);
                                continue;
                            }
                            AioQuickServer.this.config.getProcessor().stateEvent(null, StateMachine.REJECT_ACCEPT, null);
                            Logger.warn((String)"reject accept channel:{}", (Object[])new Object[]{channel});
                            AioQuickServer.this.closeChannel(channel);
                        }
                        catch (Exception e) {
                            Logger.error((String)"AcceptThread Exception", (Object[])new Object[]{e});
                        }
                    }
                }
            }, "bus-socket:AcceptThread");
            this.acceptThread.start();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
        Logger.info((String)"server started on port {},threadNum:{}", (Object[])new Object[]{this.config.getPort(), threadNum});
        Logger.info((String)"server config is {}", (Object[])new Object[]{this.config});
    }

    private void createSession(AsynchronousSocketChannel channel) {
        TcpAioSession<T> session = null;
        try {
            session = this.aioSessionFunction.apply(channel);
            session.initSession();
        }
        catch (Exception e1) {
            Logger.error((String)e1.getMessage(), (Object[])new Object[]{e1});
            if (session == null) {
                this.closeChannel(channel);
            }
            session.close();
        }
    }

    private void closeChannel(AsynchronousSocketChannel channel) {
        try {
            channel.shutdownInput();
        }
        catch (IOException e) {
            Logger.debug((String)e.getMessage(), (Object[])new Object[]{e});
        }
        try {
            channel.shutdownOutput();
        }
        catch (IOException e) {
            Logger.debug((String)e.getMessage(), (Object[])new Object[]{e});
        }
        try {
            channel.close();
        }
        catch (IOException e) {
            Logger.debug((String)"close channel exception", (Object[])new Object[]{e});
        }
    }

    public final void shutdown() {
        this.running = false;
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            Logger.warn((String)e.getMessage(), (Object[])new Object[]{e});
        }
        if (!this.asynchronousChannelGroup.isTerminated()) {
            try {
                this.asynchronousChannelGroup.shutdownNow();
            }
            catch (IOException e) {
                Logger.error((String)"shutdown exception", (Object[])new Object[]{e});
            }
        }
        try {
            this.asynchronousChannelGroup.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.error((String)"shutdown exception", (Object[])new Object[]{e});
        }
    }

    public final AioQuickServer<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final AioQuickServer<T> setBannerEnabled(boolean bannerEnabled) {
        this.config.setBannerEnabled(bannerEnabled);
        return this;
    }

    public final <V> AioQuickServer<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickServer<T> setWriteQueueCapacity(int writeQueueCapacity) {
        this.config.setWriteQueueCapacity(writeQueueCapacity);
        return this;
    }

    public final AioQuickServer<T> setThreadNum(int threadNum) {
        if (threadNum <= 1) {
            throw new InvalidParameterException("threadNum must >= 2");
        }
        this.config.setThreadNum(threadNum);
        return this;
    }
}

