/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins.ssl;

import java.io.IOException;
import java.nio.channels.CompletionHandler;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.plugins.ssl.Handshake;
import org.aoju.bus.socket.origin.plugins.ssl.SSLService;

class Completion
implements CompletionHandler<Integer, Handshake> {
    private SSLService sslService;

    public Completion(SSLService sslService) {
        this.sslService = sslService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(Integer result, Handshake attachment) {
        if (result == -1) {
            attachment.setEof(true);
        }
        Handshake handshake = attachment;
        synchronized (handshake) {
            this.sslService.doHandshake(attachment);
        }
    }

    @Override
    public void failed(Throwable exc, Handshake attachment) {
        try {
            attachment.getSocketChannel().close();
            attachment.getSslEngine().closeOutbound();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Logger.warn((String)"handshake exception", (Object[])new Object[]{exc});
    }
}

