/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.lang.reflect.Field;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.segment.BufferPage;
import org.aoju.bus.core.io.segment.BufferPool;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.AioQuickServer;
import org.aoju.bus.socket.origin.QuickTimer;
import org.aoju.bus.socket.origin.plugins.AbstractPlugin;

public class BufferPagePlugin<T>
extends AbstractPlugin {
    private int seconds = 0;
    private AioQuickServer<T> server;

    public BufferPagePlugin(AioQuickServer<T> server, int seconds) {
        this.seconds = seconds;
        this.server = server;
        this.init();
    }

    private void init() {
        long mills = TimeUnit.SECONDS.toMillis(this.seconds);
        QuickTimer.getTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (BufferPagePlugin.this.server == null) {
                    Logger.error((String)"unKnow server or client need to monitor!", (Object[])new Object[0]);
                    return;
                }
                try {
                    Field bufferPoolField = AioQuickServer.class.getDeclaredField("bufferPool");
                    bufferPoolField.setAccessible(true);
                    BufferPool pagePool = (BufferPool)bufferPoolField.get(BufferPagePlugin.this.server);
                    if (pagePool == null) {
                        Logger.error((String)"server maybe has not started!", (Object[])new Object[0]);
                        return;
                    }
                    Field field = BufferPool.class.getDeclaredField("bufferPageList");
                    field.setAccessible(true);
                    BufferPage[] pages = (BufferPage[])field.get(pagePool);
                    String logger = "";
                    for (BufferPage page : pages) {
                        logger = logger + "\r\n" + page.toString();
                    }
                    Logger.info((String)logger, (Object[])new Object[0]);
                }
                catch (Exception e) {
                    Logger.error((String)"", (Object[])new Object[]{e});
                }
            }
        }, mills, mills);
    }
}

