/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.netty;

import org.aoju.bus.socket.netty.ClientGroup;
import org.aoju.bus.socket.netty.ClientMap;
import org.aoju.bus.socket.netty.ClientService;
import org.aoju.bus.socket.netty.SocketClient;
import org.aoju.bus.socket.netty.SocketRequest;

public class CancelCommand
implements Runnable {
    private SocketRequest request;

    public CancelCommand(SocketRequest request) {
        this.request = request;
    }

    @Override
    public void run() {
        for (String topic : this.request.getTopic()) {
            if ("all".equalsIgnoreCase(topic)) {
                this.cancel(this.request.getData());
                break;
            }
            this.cancel(topic, this.request.getData());
        }
    }

    private void cancel(String data) {
        ClientGroup group = ClientService.getClientGroup();
        for (ClientMap map : group.values()) {
            if (!map.containsKey(this.request.getContext().channel().id())) continue;
            SocketClient client = (SocketClient)map.get(this.request.getContext().channel().id());
            client.cancel(data);
        }
    }

    private void cancel(String topic, String data) {
        ClientMap map;
        ClientGroup group = ClientService.getClientGroup();
        if (group.containsKey(topic) && (map = (ClientMap)group.get(topic)).containsKey(this.request.getContext().channel().id())) {
            SocketClient client = (SocketClient)map.get(this.request.getContext().channel().id());
            client.cancel(topic, data);
        }
    }
}

