/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import org.aoju.bus.core.io.segment.BufferPage;
import org.aoju.bus.core.io.segment.BufferPool;
import org.aoju.bus.core.io.segment.EventFactory;
import org.aoju.bus.core.io.segment.RingBuffer;
import org.aoju.bus.core.io.segment.VirtualBuffer;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.Protocol;
import org.aoju.bus.socket.origin.ServerConfig;
import org.aoju.bus.socket.origin.UdpAioSession;
import org.aoju.bus.socket.origin.UdpChannel;
import org.aoju.bus.socket.origin.UdpReadEvent;

public class UdpBootstrap<Request>
implements Runnable {
    private static final byte STATUS_INIT = 0;
    private static final byte STATUS_STARTING = 1;
    private static final byte STATUS_RUNNING = 2;
    private static final byte STATUS_STOPPING = 4;
    private static final byte STATUS_STOPPED = 8;
    private static int uid;
    private volatile byte status = 0;
    private Selector selector;
    private ServerConfig<Request> config = new ServerConfig();
    private RingBuffer<UdpReadEvent<Request>>[] readRingBuffers;
    private VirtualBuffer readBuffer;
    private EventFactory<UdpReadEvent<Request>> factory = new EventFactory<UdpReadEvent<Request>>(){

        public UdpReadEvent<Request> newInstance() {
            return new UdpReadEvent();
        }

        public void restEntity(UdpReadEvent<Request> entity) {
            entity.setMessage(null);
            entity.setAioSession(null);
        }
    };
    private BufferPage bufferPage = new BufferPool(1024, 1, true).allocateBufferPage();

    public UdpBootstrap(Protocol<Request> protocol, Message<Request> messageProcessor) {
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public UdpChannel<Request> open() throws IOException {
        return this.open(0);
    }

    public UdpChannel<Request> open(int port) throws IOException {
        return this.open(null, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UdpChannel<Request> open(String host, int port) throws IOException {
        if (this.selector == null) {
            UdpBootstrap udpBootstrap = this;
            synchronized (udpBootstrap) {
                if (this.selector == null) {
                    this.selector = Selector.open();
                }
            }
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (port > 0) {
            channel.socket().bind(host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port));
        }
        if (this.status == 2) {
            this.selector.wakeup();
        }
        SelectionKey selectionKey = channel.register(this.selector, 1);
        UdpChannel udpChannel = new UdpChannel(channel, selectionKey, this.config.getWriteQueueCapacity(), this.bufferPage);
        selectionKey.attach(udpChannel);
        this.initThreadServer();
        return udpChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initThreadServer() {
        if (this.status != 0) {
            return;
        }
        UdpBootstrap udpBootstrap = this;
        synchronized (udpBootstrap) {
            if (this.status != 0) {
                return;
            }
            this.updateServiceStatus((byte)1);
            this.readBuffer = this.bufferPage.allocate(this.config.getReadBufferSize());
            int uid = UdpBootstrap.uid++;
            Thread serverThread = new Thread((Runnable)this, "UDP-Selector-" + uid);
            serverThread.start();
            this.readRingBuffers = new RingBuffer[this.config.getThreadNum()];
            for (int i = 0; i < this.config.getThreadNum(); ++i) {
                final RingBuffer ringBuffer = this.readRingBuffers[i] = new RingBuffer(1024, this.factory);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        while (2 == UdpBootstrap.this.status) {
                            try {
                                int index = ringBuffer.nextReadIndex();
                                if (2 != UdpBootstrap.this.status) break;
                                UdpReadEvent event = (UdpReadEvent)ringBuffer.get(index);
                                UdpAioSession aioSession = event.getAioSession();
                                Object message = event.getMessage();
                                ringBuffer.publishReadIndex(index);
                                UdpBootstrap.this.config.getProcessor().process(aioSession, message);
                                aioSession.writeBuffer().flush();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }, "UDP-Worker-" + uid + "-" + i).start();
            }
        }
    }

    private void updateServiceStatus(byte status) {
        this.status = status;
    }

    @Override
    public void run() {
        this.updateServiceStatus((byte)2);
        while (2 == this.status) {
            try {
                this.running();
            }
            catch (ClosedSelectorException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.selector != null) {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.selector = null;
        }
        for (int i = 0; i < this.config.getThreadNum(); ++i) {
            RingBuffer<UdpReadEvent<Request>> ringBuffer = this.readRingBuffers[i];
            try {
                int index = ringBuffer.tryNextWriteIndex();
                ringBuffer.publishWriteIndex(index);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.updateServiceStatus((byte)8);
        Logger.info((String)"Channel is stop!", (Object[])new Object[0]);
    }

    private void running() throws IOException, Exception {
        Set<SelectionKey> selectionKeys = this.selector.selectedKeys();
        if (selectionKeys.isEmpty()) {
            this.selector.select();
        }
        for (SelectionKey key : selectionKeys) {
            UdpChannel udpChannel = (UdpChannel)key.attachment();
            try {
                if (!key.isValid()) {
                    udpChannel.close();
                    continue;
                }
                if (key.isReadable()) {
                    this.doRead(udpChannel);
                    continue;
                }
                if (key.isWritable()) {
                    udpChannel.doWrite();
                    continue;
                }
                Logger.warn((String)"\u5947\u602a\u4e86...", (Object[])new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        selectionKeys.clear();
    }

    private void doRead(UdpChannel channel) throws IOException, InterruptedException {
        ByteBuffer buffer = this.readBuffer.buffer();
        SocketAddress remote = channel.getChannel().receive(buffer);
        buffer.flip();
        UdpAioSession aioSession = channel.createAndCacheSession(remote);
        Request t = this.config.getProtocol().decode(buffer, aioSession);
        buffer.clear();
        if (t == null) {
            Logger.debug((String)"decode null", (Object[])new Object[0]);
            return;
        }
        if (this.config.getThreadNum() == 0) {
            this.config.getProcessor().process(aioSession, t);
            aioSession.writeBuffer().flush();
            return;
        }
        RingBuffer<UdpReadEvent<Request>> ringBuffer = this.readRingBuffers[remote.hashCode() % this.config.getThreadNum()];
        int index = -1;
        while ((index = ringBuffer.tryNextWriteIndex()) < 0) {
            channel.doWrite();
            int readIndex = ringBuffer.tryNextReadIndex();
            if (readIndex < 0) continue;
            UdpReadEvent event = (UdpReadEvent)ringBuffer.get(readIndex);
            UdpAioSession session = event.getAioSession();
            Object message = event.getMessage();
            ringBuffer.publishReadIndex(readIndex);
            this.config.getProcessor().process(session, message);
            aioSession.writeBuffer().flush();
        }
        UdpReadEvent udpEvent = (UdpReadEvent)ringBuffer.get(index);
        udpEvent.setAioSession(aioSession);
        udpEvent.setMessage(t);
        ringBuffer.publishWriteIndex(index);
    }

    public void shutdown() {
        this.status = (byte)4;
        this.selector.wakeup();
    }

    public final UdpBootstrap<Request> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final UdpBootstrap<Request> setThreadNum(int num) {
        this.config.setThreadNum(num);
        return this;
    }
}

