/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import org.aoju.bus.socket.origin.AioQuickServer;
import org.aoju.bus.socket.origin.Function;
import org.aoju.bus.socket.origin.Message;
import org.aoju.bus.socket.origin.Protocol;
import org.aoju.bus.socket.origin.SSLAioSession;
import org.aoju.bus.socket.origin.TcpAioSession;
import org.aoju.bus.socket.origin.plugins.ssl.ClientAuth;
import org.aoju.bus.socket.origin.plugins.ssl.SSLConfig;
import org.aoju.bus.socket.origin.plugins.ssl.SSLService;

public class AioSSLQuickServer<T>
extends AioQuickServer<T> {
    private SSLConfig sslConfig = new SSLConfig();
    private SSLService sslService;

    public AioSSLQuickServer(int port, Protocol<T> protocol, Message<T> messageProcessor) {
        super(port, protocol, messageProcessor);
    }

    @Override
    public void start() throws IOException {
        this.sslService = new SSLService(this.sslConfig);
        this.start0(new Function<AsynchronousSocketChannel, TcpAioSession<T>>(){

            @Override
            public TcpAioSession<T> apply(AsynchronousSocketChannel channel) {
                return new SSLAioSession(channel, AioSSLQuickServer.this.config, AioSSLQuickServer.this.aioReadCompletionHandler, AioSSLQuickServer.this.aioWriteCompletionHandler, AioSSLQuickServer.this.sslService, AioSSLQuickServer.this.bufferPool.allocateBufferPage());
            }
        });
    }

    public AioSSLQuickServer<T> setKeyStore(String keyStoreFile, String keystorePassword) {
        this.sslConfig.setKeyFile(keyStoreFile);
        this.sslConfig.setKeystorePassword(keystorePassword);
        return this;
    }

    public AioSSLQuickServer<T> setKeyPassword(String keyPassword) {
        this.sslConfig.setKeyPassword(keyPassword);
        return this;
    }

    public AioSSLQuickServer<T> setTrust(String trustFile, String trustPassword) {
        this.sslConfig.setTrustFile(trustFile);
        this.sslConfig.setTrustPassword(trustPassword);
        return this;
    }

    public AioSSLQuickServer<T> setClientAuth(ClientAuth clientAuth) {
        this.sslConfig.setClientAuth(clientAuth);
        return this;
    }
}

