/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.aoju.bus.socket.netty.ClientService;
import org.aoju.bus.socket.netty.CommandExecutor;
import org.aoju.bus.socket.netty.RemoveCommand;
import org.aoju.bus.socket.netty.RequestDecoder;
import org.aoju.bus.socket.netty.RequestHandler;
import org.aoju.bus.socket.netty.SocketRequest;

@ChannelHandler.Sharable
public class SocketHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private RequestDecoder decoder = new RequestDecoder();

    protected void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        String message = msg.text();
        SocketRequest request = this.decoder.decode(ctx, message);
        if (request != null) {
            RequestHandler.execute(request);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        ClientService.active(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        CommandExecutor.execute(new RemoveCommand(ctx));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().close();
    }
}

