/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.netty;

import io.netty.channel.ChannelHandlerContext;
import org.aoju.bus.socket.netty.ClientGroup;
import org.aoju.bus.socket.netty.ClientMap;
import org.aoju.bus.socket.netty.CommandExecutor;
import org.aoju.bus.socket.netty.PublishCommand;
import org.aoju.bus.socket.netty.SocketClient;

public class ClientService {
    private static ClientMap activeClients = new ClientMap();
    private static ClientGroup group = new ClientGroup();

    public static void active(ChannelHandlerContext context) {
        activeClients.put(context.channel().id(), new SocketClient(context.channel()));
    }

    public static void inactive(ChannelHandlerContext context) {
        activeClients.remove(context.channel().id());
    }

    public static SocketClient getClient(ChannelHandlerContext context) {
        return (SocketClient)activeClients.get(context.channel().id());
    }

    public static ClientMap getClients() {
        return activeClients;
    }

    public static SocketClient subscribe(ChannelHandlerContext context, String topic) {
        if (group.containsKey(topic)) {
            ClientMap map = (ClientMap)group.get(topic);
            return ClientService.subscribe(context, topic, map);
        }
        ClientMap map = new ClientMap();
        group.put(topic, map);
        return ClientService.subscribe(context, topic, map);
    }

    private static SocketClient subscribe(ChannelHandlerContext context, String topic, ClientMap map) {
        if (map.containsKey(context.channel().id())) {
            SocketClient client = (SocketClient)map.get(context.channel().id());
            client.subscribe(topic);
            return client;
        }
        SocketClient client = ClientService.getClient(context);
        client.subscribe(topic);
        map.put(context.channel().id(), client);
        return client;
    }

    public static void remove(ChannelHandlerContext context) {
        ClientService.inactive(context);
        for (ClientMap map : group.values()) {
            map.remove(context.channel().id());
        }
    }

    public static void publish(String topic, String message) {
        CommandExecutor.execute(new PublishCommand(topic, message));
    }

    public static ClientGroup getClientGroup() {
        return group;
    }
}

