/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.Message;

abstract class GroupMessage<T>
implements Message<T> {
    private Map<String, GroupUnit> sessionGroup = new ConcurrentHashMap<String, GroupUnit>();

    GroupMessage() {
    }

    @Override
    public final synchronized void join(String group, AioSession<T> session) {
        GroupUnit groupUnit = this.sessionGroup.get(group);
        if (groupUnit == null) {
            groupUnit = new GroupUnit();
            this.sessionGroup.put(group, groupUnit);
        }
        groupUnit.groupList.add(session);
    }

    @Override
    public final synchronized void remove(String group, AioSession<T> session) {
        GroupUnit groupUnit = this.sessionGroup.get(group);
        if (groupUnit == null) {
            return;
        }
        groupUnit.groupList.remove(session);
        if (groupUnit.groupList.isEmpty()) {
            this.sessionGroup.remove(group);
        }
    }

    @Override
    public final void remove(AioSession<T> session) {
        for (String group : this.sessionGroup.keySet()) {
            this.remove(group, session);
        }
    }

    @Override
    public void writeToGroup(String group, byte[] t) {
        GroupUnit groupUnit = this.sessionGroup.get(group);
        for (AioSession aioSession : groupUnit.groupList) {
            try {
                aioSession.writeBuffer().write(t);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class GroupUnit {
        Set<AioSession<T>> groupList = new HashSet();

        private GroupUnit() {
        }
    }
}

