/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.nio.channels.AsynchronousChannelGroup;
import org.aoju.bus.socket.origin.AioQuickClient;
import org.aoju.bus.socket.origin.AioSession;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.plugins.AbstractPlugin;

class ReconnectPlugin<T>
extends AbstractPlugin<T> {
    private AioQuickClient<T> client;
    private boolean shutdown = false;
    private AsynchronousChannelGroup asynchronousChannelGroup;

    public ReconnectPlugin(AioQuickClient<T> client) {
        this(client, null);
    }

    public ReconnectPlugin(AioQuickClient<T> client, AsynchronousChannelGroup asynchronousChannelGroup) {
        this.client = client;
        this.asynchronousChannelGroup = asynchronousChannelGroup;
    }

    @Override
    public void stateEvent(StateMachine stateMachineEnum, AioSession<T> session, Throwable throwable) {
        if (stateMachineEnum != StateMachine.SESSION_CLOSED || this.shutdown) {
            return;
        }
        try {
            if (this.asynchronousChannelGroup == null) {
                this.client.start();
            } else {
                this.client.start(this.asynchronousChannelGroup);
            }
        }
        catch (Exception e) {
            this.shutdown = true;
            e.printStackTrace();
        }
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

