/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin.plugins;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.plugins.AbstractPlugin;

public final class BlackListPlugin<T>
extends AbstractPlugin<T> {
    private ConcurrentLinkedQueue<BlackListRule> ipBlackList = new ConcurrentLinkedQueue();

    @Override
    public boolean acceptMonitor(AsynchronousSocketChannel channel) {
        InetSocketAddress inetSocketAddress = null;
        try {
            inetSocketAddress = (InetSocketAddress)channel.getRemoteAddress();
        }
        catch (IOException e) {
            Logger.error((String)"get remote address error.", (Object[])new Object[]{e});
        }
        if (inetSocketAddress == null) {
            return true;
        }
        for (BlackListRule rule : this.ipBlackList) {
            if (rule.access(inetSocketAddress)) continue;
            return false;
        }
        return true;
    }

    public void addRule(BlackListRule rule) {
        this.ipBlackList.add(rule);
    }

    public void removeRule(BlackListRule rule) {
        this.ipBlackList.remove(rule);
    }

    public static interface BlackListRule {
        public boolean access(InetSocketAddress var1);
    }
}

