/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.origin;

import java.nio.channels.CompletionHandler;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.origin.NetMonitor;
import org.aoju.bus.socket.origin.StateMachine;
import org.aoju.bus.socket.origin.TcpAioSession;

class TcpWriteHandler<T>
implements CompletionHandler<Integer, TcpAioSession<T>> {
    TcpWriteHandler() {
    }

    @Override
    public void completed(Integer result, TcpAioSession<T> aioSession) {
        try {
            NetMonitor<T> monitor = aioSession.getServerConfig().getMonitor();
            if (monitor != null) {
                monitor.writeMonitor(aioSession, result);
            }
            aioSession.writeToChannel();
        }
        catch (Exception e) {
            this.failed((Throwable)e, aioSession);
        }
    }

    @Override
    public void failed(Throwable exc, TcpAioSession<T> aioSession) {
        try {
            aioSession.getServerConfig().getProcessor().stateEvent(aioSession, StateMachine.OUTPUT_EXCEPTION, exc);
        }
        catch (Exception e) {
            Logger.debug((String)e.getMessage(), (Object[])new Object[]{e});
        }
        try {
            aioSession.close();
        }
        catch (Exception e) {
            Logger.debug((String)e.getMessage(), (Object[])new Object[]{e});
        }
    }
}

