/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.socket.AsynchronousServerSocketChannel;
import org.aoju.bus.socket.AsynchronousSocketChannel;
import org.aoju.bus.socket.WorkerRegister;

class AsynchronousChannelGroup
extends java.nio.channels.AsynchronousChannelGroup {
    public static final int MAX_INVOKER = 8;
    private static final String WRITE_THREAD_NUM = "org.aoju.bus.socket.writeThreadNum";
    private static final String ACCEPT_THREAD_NUM = "org.aoju.bus.socket.acceptThreadNum";
    private final ExecutorService readExecutorService;
    private final ExecutorService writeExecutorService;
    private final Worker[] writeWorkers;
    private final Worker[] readWorkers;
    private final AtomicInteger readIndex = new AtomicInteger(0);
    private final AtomicInteger writeIndex = new AtomicInteger(0);
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private ExecutorService acceptExecutorService;
    private Worker[] acceptWorkers = null;
    private boolean running = true;

    protected AsynchronousChannelGroup(AsynchronousChannelProvider provider, ExecutorService readExecutorService, int threadNum) throws IOException {
        super(provider);
        int i;
        this.readExecutorService = readExecutorService;
        this.readWorkers = new Worker[threadNum];
        for (int i2 = 0; i2 < threadNum; ++i2) {
            this.readWorkers[i2] = new Worker(Selector.open(), 1);
            this.readExecutorService.execute(this.readWorkers[i2]);
        }
        int writeThreadNum = this.getIntSystemProperty(WRITE_THREAD_NUM, 1);
        int acceptThreadNum = this.getIntSystemProperty(ACCEPT_THREAD_NUM, 1);
        this.writeExecutorService = this.getThreadPoolExecutor("bus-socket:write-", writeThreadNum);
        this.writeWorkers = new Worker[writeThreadNum];
        int validSelectionKey = 12;
        if (acceptThreadNum <= 0) {
            validSelectionKey |= 0x10;
            this.acceptWorkers = this.writeWorkers;
        }
        for (i = 0; i < writeThreadNum; ++i) {
            this.writeWorkers[i] = new Worker(Selector.open(), validSelectionKey);
            this.writeExecutorService.execute(this.writeWorkers[i]);
        }
        if (acceptThreadNum > 0) {
            this.acceptExecutorService = this.getThreadPoolExecutor("bus-socket:accept-", acceptThreadNum);
            this.acceptWorkers = new Worker[acceptThreadNum];
            for (i = 0; i < acceptThreadNum; ++i) {
                this.acceptWorkers[i] = new Worker(Selector.open(), 16);
                this.acceptExecutorService.execute(this.acceptWorkers[i]);
            }
        }
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "bus-socket:scheduled"));
    }

    private ThreadPoolExecutor getThreadPoolExecutor(final String prefix, int threadNum) {
        return new ThreadPoolExecutor(threadNum, threadNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
            private final AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, prefix + this.atomicInteger.getAndIncrement());
            }
        });
    }

    private int getIntSystemProperty(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public void removeOps(SelectionKey selectionKey, int opt) {
        if (selectionKey.isValid() && (selectionKey.interestOps() & opt) != 0) {
            selectionKey.interestOps(selectionKey.interestOps() & ~opt);
        }
    }

    public Worker getReadWorker() {
        return this.readWorkers[this.index(this.readWorkers.length, this.readIndex)];
    }

    public Worker getWriteWorker() {
        return this.writeWorkers[this.index(this.writeWorkers.length, this.writeIndex)];
    }

    public Worker getAcceptWorker() {
        return this.acceptWorkers[this.index(this.acceptWorkers.length, this.writeIndex)];
    }

    public ScheduledThreadPoolExecutor getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    private int index(int arrayLength, AtomicInteger index) {
        int i = index.getAndIncrement() % arrayLength;
        if (i < 0) {
            i = -i;
        }
        return i;
    }

    @Override
    public boolean isShutdown() {
        return this.readExecutorService.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.readExecutorService.isTerminated();
    }

    @Override
    public void shutdown() {
        this.running = false;
        this.readExecutorService.shutdown();
        this.writeExecutorService.shutdown();
        if (this.acceptExecutorService != null) {
            this.acceptExecutorService.shutdown();
        }
        this.scheduledExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.running = false;
        this.readExecutorService.shutdownNow();
        this.writeExecutorService.shutdownNow();
        if (this.acceptExecutorService != null) {
            this.acceptExecutorService.shutdownNow();
        }
        this.scheduledExecutor.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.readExecutorService.awaitTermination(timeout, unit);
    }

    public void interestOps(Worker worker, SelectionKey selectionKey, int opt) {
        if ((selectionKey.interestOps() & opt) != 0) {
            return;
        }
        if (worker.selector != selectionKey.selector()) {
            throw new RuntimeException();
        }
        selectionKey.interestOps(selectionKey.interestOps() | opt);
        if (worker.getWorkerThread() != Thread.currentThread()) {
            selectionKey.selector().wakeup();
        }
    }

    class Worker
    implements Runnable {
        private final int validSelectionKey;
        private final Selector selector;
        private final ConcurrentLinkedQueue<WorkerRegister> registers = new ConcurrentLinkedQueue();
        int invoker = 0;
        private Thread workerThread;

        Worker(Selector selector, int validSelectionKey) {
            this.selector = selector;
            this.validSelectionKey = validSelectionKey;
        }

        void addRegister(WorkerRegister register) {
            this.registers.offer(register);
            this.selector.wakeup();
        }

        public Thread getWorkerThread() {
            return this.workerThread;
        }

        @Override
        public void run() {
            this.workerThread = Thread.currentThread();
            Set<SelectionKey> keySet = this.selector.selectedKeys();
            try {
                while (AsynchronousChannelGroup.this.running) {
                    WorkerRegister register;
                    while ((register = this.registers.poll()) != null) {
                        register.callback(this.selector);
                    }
                    if (keySet.isEmpty() && this.selector.select() == 0) continue;
                    Iterator<SelectionKey> keyIterator = keySet.iterator();
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        keyIterator.remove();
                        this.invoker = 0;
                        if (!key.isValid()) continue;
                        if ((this.validSelectionKey & 0x10) > 0 && key.isAcceptable()) {
                            AsynchronousServerSocketChannel serverSocketChannel = (AsynchronousServerSocketChannel)key.attachment();
                            serverSocketChannel.doAccept();
                            continue;
                        }
                        AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)key.attachment();
                        if ((this.validSelectionKey & 4) > 0 && key.isWritable()) {
                            AsynchronousChannelGroup.this.removeOps(key, 4);
                            asynchronousSocketChannel.doWrite();
                            continue;
                        }
                        if ((this.validSelectionKey & 1) > 0 && key.isReadable()) {
                            asynchronousSocketChannel.doRead();
                            continue;
                        }
                        if ((this.validSelectionKey & 8) <= 0 || !key.isConnectable()) continue;
                        asynchronousSocketChannel.doConnect();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

