/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AcceptPendingException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.concurrent.Future;
import org.aoju.bus.socket.AsynchronousChannelGroup;
import org.aoju.bus.socket.AsynchronousSocketChannel;
import org.aoju.bus.socket.FutureCompletionHandler;

final class AsynchronousServerSocketChannel
extends java.nio.channels.AsynchronousServerSocketChannel {
    private final ServerSocketChannel serverSocketChannel;
    private final AsynchronousChannelGroup asynchronousChannelGroup;
    private final AsynchronousChannelGroup.Worker acceptWorker;
    private CompletionHandler<java.nio.channels.AsynchronousSocketChannel, Object> acceptCompletionHandler;
    private FutureCompletionHandler<java.nio.channels.AsynchronousSocketChannel, Void> acceptFuture;
    private Object attachment;
    private SelectionKey selectionKey;
    private boolean acceptPending;

    protected AsynchronousServerSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        super(asynchronousChannelGroup.provider());
        this.asynchronousChannelGroup = asynchronousChannelGroup;
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.configureBlocking(false);
        this.acceptWorker = asynchronousChannelGroup.getAcceptWorker();
    }

    @Override
    public java.nio.channels.AsynchronousServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        this.serverSocketChannel.bind(local, backlog);
        return this;
    }

    @Override
    public <T> java.nio.channels.AsynchronousServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        this.serverSocketChannel.setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.serverSocketChannel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.serverSocketChannel.supportedOptions();
    }

    @Override
    public <A> void accept(A attachment, CompletionHandler<java.nio.channels.AsynchronousSocketChannel, ? super A> handler) {
        if (this.acceptPending) {
            throw new AcceptPendingException();
        }
        this.acceptPending = true;
        this.acceptCompletionHandler = handler;
        this.attachment = attachment;
        this.doAccept();
    }

    public void doAccept() {
        try {
            if (this.acceptFuture != null && this.acceptFuture.isDone()) {
                this.resetAccept();
                this.asynchronousChannelGroup.removeOps(this.selectionKey, 16);
                return;
            }
            boolean directAccept = this.acceptWorker.getWorkerThread() == Thread.currentThread() && this.acceptWorker.invoker++ < 8;
            SocketChannel socketChannel = null;
            if (directAccept) {
                socketChannel = this.serverSocketChannel.accept();
            }
            if (socketChannel != null) {
                AsynchronousSocketChannel asynchronousSocketChannel = new AsynchronousSocketChannel(this.asynchronousChannelGroup, socketChannel);
                socketChannel.finishConnect();
                CompletionHandler<java.nio.channels.AsynchronousSocketChannel, Object> completionHandler = this.acceptCompletionHandler;
                Object attach = this.attachment;
                this.resetAccept();
                completionHandler.completed(asynchronousSocketChannel, attach);
                if (!this.acceptPending && this.selectionKey != null) {
                    this.asynchronousChannelGroup.removeOps(this.selectionKey, 16);
                }
            } else if (this.selectionKey == null) {
                this.acceptWorker.addRegister(selector -> {
                    try {
                        this.selectionKey = this.serverSocketChannel.register(selector, 16);
                        this.selectionKey.attach(this);
                    }
                    catch (ClosedChannelException e) {
                        this.acceptCompletionHandler.failed(e, this.attachment);
                    }
                });
            } else {
                this.asynchronousChannelGroup.interestOps(this.acceptWorker, this.selectionKey, 16);
            }
        }
        catch (IOException e) {
            this.acceptCompletionHandler.failed(e, this.attachment);
        }
    }

    private void resetAccept() {
        this.acceptPending = false;
        this.acceptFuture = null;
        this.acceptCompletionHandler = null;
        this.attachment = null;
    }

    @Override
    public Future<java.nio.channels.AsynchronousSocketChannel> accept() {
        FutureCompletionHandler acceptFuture = new FutureCompletionHandler();
        this.accept(null, acceptFuture);
        this.acceptFuture = acceptFuture;
        return acceptFuture;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.serverSocketChannel.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.serverSocketChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.serverSocketChannel.close();
    }
}

