/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.nio.ByteBuffer;
import org.aoju.bus.socket.SocketDecoder;

public class FixedLengthDecoder
implements SocketDecoder {
    private final ByteBuffer buffer;
    private boolean finishRead;

    public FixedLengthDecoder(int frameLength) {
        if (frameLength <= 0) {
            throw new IllegalArgumentException("frameLength must be a positive integer: " + frameLength);
        }
        this.buffer = ByteBuffer.allocate(frameLength);
    }

    @Override
    public boolean decode(ByteBuffer byteBuffer) {
        if (this.finishRead) {
            throw new RuntimeException("delimiter has finish read");
        }
        if (this.buffer.remaining() >= byteBuffer.remaining()) {
            this.buffer.put(byteBuffer);
        } else {
            int limit = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + this.buffer.remaining());
            this.buffer.put(byteBuffer);
            byteBuffer.limit(limit);
        }
        if (this.buffer.hasRemaining()) {
            return false;
        }
        this.buffer.flip();
        this.finishRead = true;
        return true;
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

