/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.io.ByteBuffer;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.BufferFactory;
import org.aoju.bus.socket.CompletionReadHandler;
import org.aoju.bus.socket.CompletionWriteHandler;
import org.aoju.bus.socket.MessageProcessor;
import org.aoju.bus.socket.Protocol;
import org.aoju.bus.socket.ServerConfig;
import org.aoju.bus.socket.TcpAioSession;

public final class QuickAioClient<T> {
    private final ServerConfig<T> config = new ServerConfig();
    private TcpAioSession<T> session;
    private ByteBuffer bufferPool = null;
    private ByteBuffer innerBufferPool = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private SocketAddress localAddress;
    private int connectTimeout;

    public QuickAioClient(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setHost(host);
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public AioSession start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        AsynchronousSocketChannel socketChannel = null;
        try {
            socketChannel = AsynchronousSocketChannel.open(asynchronousChannelGroup);
            if (this.bufferPool == null) {
                this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
            }
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    socketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.localAddress != null) {
                socketChannel.bind(this.localAddress);
            }
            Future<Void> future = socketChannel.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()));
            if (this.connectTimeout > 0) {
                future.get(this.connectTimeout, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
            AsynchronousSocketChannel connectedChannel = socketChannel;
            if (this.config.getMonitor() != null) {
                connectedChannel = this.config.getMonitor().shouldAccept(socketChannel);
            }
            if (connectedChannel == null) {
                throw new RuntimeException("NetMonitor refuse channel");
            }
            this.session = new TcpAioSession<T>(connectedChannel, this.config, new CompletionReadHandler(), new CompletionWriteHandler(), this.bufferPool.allocateBufferPage());
            this.session.initSession();
            return this.session;
        }
        catch (Exception e) {
            if (socketChannel != null) {
                IoKit.close((AsynchronousSocketChannel)socketChannel);
            }
            this.shutdownNow();
            throw new IOException(e);
        }
    }

    public final AioSession start() throws IOException {
        this.asynchronousChannelGroup = AsynchronousChannelGroup.withFixedThreadPool(2, Thread::new);
        return this.start(this.asynchronousChannelGroup);
    }

    public final void shutdown() {
        this.showdown0(false);
    }

    public final void shutdownNow() {
        this.showdown0(true);
    }

    private void showdown0(boolean flag) {
        if (this.session != null) {
            this.session.close(flag);
            this.session = null;
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
        }
        if (this.innerBufferPool != null) {
            this.innerBufferPool.release();
        }
    }

    public final QuickAioClient<T> setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final <V> QuickAioClient<T> setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final QuickAioClient<T> bindLocal(String local, int port) {
        this.localAddress = local == null ? new InetSocketAddress(port) : new InetSocketAddress(local, port);
        return this;
    }

    public final QuickAioClient<T> setBufferPagePool(ByteBuffer bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public final QuickAioClient<T> setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }

    public final QuickAioClient<T> setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public final QuickAioClient<T> connectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }
}

