/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.socket.MessageProcessor;
import org.aoju.bus.socket.UdpAioSession;

class UdpDispatcher<T>
implements Runnable {
    public final RequestTask EXECUTE_TASK_OR_SHUTDOWN = new RequestTask(null, null);
    private final BlockingQueue<RequestTask> taskQueue = new LinkedBlockingQueue<RequestTask>();
    private final MessageProcessor<T> processor;

    public UdpDispatcher(MessageProcessor<T> processor) {
        this.processor = processor;
    }

    @Override
    public void run() {
        block3: while (true) {
            try {
                while (true) {
                    RequestTask unit;
                    if ((unit = this.taskQueue.take()) == this.EXECUTE_TASK_OR_SHUTDOWN) {
                        Logger.info((String)"shutdown thread:{}", (Object[])new Object[]{Thread.currentThread()});
                        break block3;
                    }
                    this.processor.process(unit.session, unit.request);
                    unit.session.writeBuffer().flush();
                }
            }
            catch (InterruptedException e) {
                Logger.info((String)"InterruptedException", (Object[])new Object[]{e});
                continue;
            }
            catch (Exception e) {
                Logger.error((String)e.getClass().getName(), (Object[])new Object[]{e});
                continue;
            }
            break;
        }
    }

    public void dispatch(UdpAioSession session, T request) {
        this.dispatch(new RequestTask(session, request));
    }

    public void dispatch(RequestTask requestTask) {
        this.taskQueue.offer(requestTask);
    }

    class RequestTask {
        UdpAioSession session;
        T request;

        public RequestTask(UdpAioSession session, T request) {
            this.session = session;
            this.request = request;
        }
    }
}

