/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.plugins;

import java.io.InputStream;
import java.nio.channels.AsynchronousSocketChannel;
import org.aoju.bus.core.io.ByteBuffer;
import org.aoju.bus.socket.BufferFactory;
import org.aoju.bus.socket.plugins.AbstractPlugin;
import org.aoju.bus.socket.secure.ClientAuth;
import org.aoju.bus.socket.secure.SslService;
import org.aoju.bus.socket.secure.SslSocketChannel;

public final class SslPlugin<T>
extends AbstractPlugin<T> {
    private final ByteBuffer bufferPool;
    private SslService sslService;
    private boolean init = false;

    public SslPlugin() {
        this.bufferPool = BufferFactory.DISABLED_BUFFER_FACTORY.create();
    }

    public SslPlugin(ByteBuffer bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void initForServer(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword, ClientAuth clientAuth) {
        this.initCheck();
        this.sslService = new SslService(false, clientAuth);
        this.sslService.initKeyStore(keyStoreInputStream, keyStorePassword, keyPassword);
    }

    public void initForClient() {
        this.initForClient(null, null);
    }

    public void initForClient(InputStream trustInputStream, String trustPassword) {
        this.initCheck();
        this.sslService = new SslService(true, null);
        this.sslService.initTrust(trustInputStream, trustPassword);
    }

    private void initCheck() {
        if (this.init) {
            throw new RuntimeException("plugin is already init");
        }
        this.init = true;
    }

    @Override
    public final AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new SslSocketChannel(channel, this.sslService, this.bufferPool.allocateBufferPage());
    }
}

